/*
 * Decompiled with CFR 0.152.
 */
package lol.hub.torchify;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public final class Plugin
extends JavaPlugin
implements Listener {
    private static final BlockData torchData = Material.TORCH.createBlockData();
    private static final Path configActives = Path.of("plugins", "torchify", "active.txt");
    private final Set<UUID> actives = ConcurrentHashMap.newKeySet();
    private final CommandExecutor toggle = (sender, command, label, args) -> {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command is not available for non-players.");
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        TextComponent message = Component.text((String)"Torching ");
        if (this.actives.contains(uuid)) {
            this.actives.remove(uuid);
            message = (TextComponent)message.append(Component.text((String)"disabled").color((TextColor)NamedTextColor.RED));
        } else {
            this.actives.add(uuid);
            message = (TextComponent)message.append(Component.text((String)"enabled").color((TextColor)NamedTextColor.GREEN));
        }
        player.sendMessage((Component)message);
        this.saveActives();
        return true;
    };

    private void loadActives() {
        this.actives.clear();
        try {
            if (configActives.toFile().exists()) {
                List<String> lines = Files.readAllLines(configActives);
                for (String line : lines) {
                    if (line.isBlank()) continue;
                    this.actives.add(UUID.fromString(line));
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().warning(ex.toString());
        }
    }

    private void saveActives() {
        configActives.getParent().toFile().mkdirs();
        try {
            Files.writeString(configActives, (CharSequence)this.actives.stream().map(UUID::toString).collect(Collectors.joining(System.lineSeparator())), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            this.getLogger().warning(ex.toString());
        }
    }

    private static boolean placeTorch(Block center, int radius) {
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    Block above;
                    Block block = center.getRelative(x, y, z);
                    if (!block.isSolid() || !(above = block.getRelative(BlockFace.UP)).isEmpty() || !above.canPlace(torchData) || above.getLightFromBlocks() >= 8) continue;
                    above.setType(Material.TORCH);
                    block.tick();
                    return true;
                }
            }
        }
        return false;
    }

    public void onEnable() {
        PluginCommand cmd = this.getCommand("torchify");
        cmd.setExecutor(this.toggle);
        cmd.setTabCompleter((sender, command, label, args) -> Collections.emptyList());
        this.loadActives();
        this.getServer().getScheduler().runTaskTimer((org.bukkit.plugin.Plugin)this, () -> this.getServer().getOnlinePlayers().stream().filter(player -> this.actives.contains(player.getUniqueId())).filter(player -> !player.isDead()).filter(player -> !player.isSleeping()).filter(player -> player.getGameMode() != GameMode.ADVENTURE).filter(player -> player.getGameMode() != GameMode.SPECTATOR).forEach(player -> Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).filter(stack -> !stack.isEmpty()).filter(stack -> stack.getType() == Material.TORCH).findFirst().ifPresent(stack -> {
            Block block = player.getWorld().getBlockAt(player.getLocation());
            if (Plugin.placeTorch(block, 5)) {
                stack.setAmount(stack.getAmount() - 1);
                player.getWorld().playSound(block.getLocation(), Sound.BLOCK_CANDLE_PLACE, 0.33f, 0.8f);
            }
        })), 20L, 20L);
    }
}

