/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin.converter;

import me.youhavetrouble.standin.StandIn;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityConverter<F extends Entity, T extends Entity> {
    public static final NamespacedKey PLAYER_PROFILE_KEY = new NamespacedKey("stand-in", "player-profile");
    public static final NamespacedKey CUSTOM_NAME_KEY = new NamespacedKey("stand-in", "raw-custom-name");

    @NotNull
    public EntityType entityFrom();

    @NotNull
    public EntityType entityTo();

    public T spawn(@NotNull F var1);

    default public void markAsTransformed(@NotNull T entity) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        pdc.set(StandIn.KEY, PersistentDataType.BYTE, (Object)1);
    }

    @Nullable
    public static String getRawEntityName(@NotNull Entity entity) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        String pdcCustomName = (String)pdc.get(CUSTOM_NAME_KEY, PersistentDataType.STRING);
        if (pdcCustomName != null) {
            return pdcCustomName;
        }
        Component entityCustomName = entity.customName();
        if (entityCustomName != null) {
            return PlainTextComponentSerializer.plainText().serialize(entityCustomName);
        }
        return null;
    }

    public static void saveRawEntityName(@NotNull Entity entity, @Nullable String rawName) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (rawName != null && !rawName.isEmpty()) {
            pdc.set(CUSTOM_NAME_KEY, PersistentDataType.STRING, (Object)rawName);
            return;
        }
        pdc.remove(CUSTOM_NAME_KEY);
    }
}

