/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin.converter;

import me.youhavetrouble.standin.StandIn;
import me.youhavetrouble.standin.converter.EntityConverter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class MannequinToArmorStandConverter
implements EntityConverter<Mannequin, ArmorStand> {
    @Override
    @NotNull
    public EntityType entityFrom() {
        return EntityType.MANNEQUIN;
    }

    @Override
    @NotNull
    public EntityType entityTo() {
        return EntityType.ARMOR_STAND;
    }

    @Override
    public ArmorStand spawn(@NotNull Mannequin from) {
        try {
            return (ArmorStand)from.getWorld().spawn(from.getLocation(), ArmorStand.class, armorStand -> {
                this.markAsTransformed(armorStand);
                armorStand.customName(from.customName());
                EntityConverter.saveRawEntityName((Entity)armorStand, EntityConverter.getRawEntityName((Entity)from));
                armorStand.setGravity(from.hasGravity());
                armorStand.setCanMove(!from.isImmovable());
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    try {
                        armorStand.setItem(slot, from.getEquipment().getItem(slot));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                PersistentDataContainer pdc = armorStand.getPersistentDataContainer();
                String profileName = from.getProfile().name();
                if (profileName != null && !profileName.isEmpty()) {
                    pdc.set(EntityConverter.PLAYER_PROFILE_KEY, PersistentDataType.STRING, (Object)profileName);
                }
            });
        }
        catch (IllegalArgumentException e) {
            ((StandIn)StandIn.getPlugin(StandIn.class)).getSLF4JLogger().warn("Failed to spawn entity", (Throwable)e);
            return null;
        }
    }
}

