/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import me.youhavetrouble.standin.entity.ArmorStandHandler;
import me.youhavetrouble.standin.entity.EntityHandler;
import me.youhavetrouble.standin.entity.MannequinHandler;
import me.youhavetrouble.standin.stand.StandinInteractionListener;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class StandIn
extends JavaPlugin {
    public static final NamespacedKey KEY = new NamespacedKey("stand-in", "stand-in");
    public final Permission editAnyEntityPermission = new Permission("standin.edit-anything", PermissionDefault.FALSE);
    public final Permission convertAnyEntityPermission = new Permission("standin.convert-anything", PermissionDefault.FALSE);
    private final Map<EntityType, EntityHandler<? extends Entity>> entityHandlers = new HashMap<EntityType, EntityHandler<? extends Entity>>();

    public void onEnable() {
        this.getServer().getPluginManager().addPermissions(List.of(this.editAnyEntityPermission, this.convertAnyEntityPermission));
        this.entityHandlers.put(EntityType.ARMOR_STAND, new ArmorStandHandler());
        this.entityHandlers.put(EntityType.MANNEQUIN, new MannequinHandler());
        this.entityHandlers.keySet().forEach(entityType -> {
            Permission editPermission = new Permission("standin.edit." + entityType.getKey().value(), PermissionDefault.OP);
            Permission convertPermission = new Permission("standin.change_type." + entityType.getKey().value(), PermissionDefault.OP);
            this.getServer().getPluginManager().addPermission(editPermission);
            this.getServer().getPluginManager().addPermission(convertPermission);
        });
        this.getServer().getPluginManager().registerEvents((Listener)new StandinInteractionListener(this), (Plugin)this);
    }

    @Nullable
    public EntityHandler<? extends Entity> getEntityHandler(EntityType entityType) {
        return this.entityHandlers.get(entityType);
    }
}

