/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin.converter;

import io.papermc.paper.datacomponent.item.ResolvableProfile;
import me.youhavetrouble.standin.StandIn;
import me.youhavetrouble.standin.converter.EntityConverter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class ArmorStandToMannequinConverter
implements EntityConverter<ArmorStand, Mannequin> {
    @Override
    @NotNull
    public EntityType entityFrom() {
        return EntityType.ARMOR_STAND;
    }

    @Override
    @NotNull
    public EntityType entityTo() {
        return EntityType.MANNEQUIN;
    }

    @Override
    public Mannequin spawn(@NotNull ArmorStand from) {
        try {
            return (Mannequin)from.getWorld().spawn(from.getLocation(), Mannequin.class, mannequin -> {
                mannequin.customName(from.customName());
                mannequin.setImmovable(!from.canMove());
                mannequin.setGravity(from.hasGravity());
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    try {
                        mannequin.getEquipment().setItem(slot, from.getItem(slot));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                PersistentDataContainer pdc = from.getPersistentDataContainer();
                String profileName = (String)pdc.get(EntityConverter.PLAYER_PROFILE_KEY, PersistentDataType.STRING);
                if (profileName != null) {
                    try {
                        mannequin.setProfile((ResolvableProfile)ResolvableProfile.resolvableProfile().name(profileName).build());
                    }
                    catch (IllegalArgumentException e) {
                        ((StandIn)StandIn.getPlugin(StandIn.class)).getSLF4JLogger().warn("Failed to set profile for mannequin", (Throwable)e);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            ((StandIn)StandIn.getPlugin(StandIn.class)).getSLF4JLogger().warn("Failed to spawn entity", (Throwable)e);
            return null;
        }
    }
}

