/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin.entity;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.youhavetrouble.standin.converter.ArmorStandToMannequinConverter;
import me.youhavetrouble.standin.entity.EntityHandler;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ArmorStandHandler
extends EntityHandler<ArmorStand> {
    public ArmorStandHandler() {
        super(ArmorStand.class);
        this.addConverter(new ArmorStandToMannequinConverter());
    }

    @Override
    public Dialog editDialog(@NotNull Player player, ArmorStand armorStand) {
        if (armorStand == null || armorStand.isDead()) {
            return null;
        }
        if (!this.canUseAction(player, armorStand, EntityHandler.EntityAction.EDIT)) {
            return null;
        }
        UUID entityId = armorStand.getUniqueId();
        UUID playerId = player.getUniqueId();
        ArrayList<BooleanDialogInput> inputs = new ArrayList<BooleanDialogInput>();
        inputs.add(DialogInput.bool((String)"invisible", (Component)Component.text((String)"Invisible")).initial(armorStand.isInvisible()).build());
        inputs.add(DialogInput.bool((String)"canMove", (Component)Component.text((String)"Can move")).initial(armorStand.canMove()).build());
        inputs.add(DialogInput.bool((String)"gravity", (Component)Component.text((String)"Gravity")).initial(armorStand.hasGravity()).build());
        inputs.add(DialogInput.bool((String)"basePlate", (Component)Component.text((String)"Base plate")).initial(armorStand.hasBasePlate()).build());
        inputs.add(DialogInput.bool((String)"arms", (Component)Component.text((String)"Arms")).initial(armorStand.hasArms()).build());
        inputs.add(DialogInput.bool((String)"small", (Component)Component.text((String)"Small")).initial(armorStand.isSmall()).build());
        ActionButton saveButton = ActionButton.builder((Component)Component.text((String)"Save")).action((DialogAction)DialogAction.customClick((view, audience) -> {
            if (!(audience instanceof Player)) {
                return;
            }
            Player callbackPlayer = (Player)audience;
            if (playerId != callbackPlayer.getUniqueId()) {
                return;
            }
            Entity entity = callbackPlayer.getWorld().getEntity(entityId);
            if (!(entity instanceof ArmorStand)) {
                return;
            }
            ArmorStand stand = (ArmorStand)entity;
            if (!this.canUseAction(callbackPlayer, stand, EntityHandler.EntityAction.EDIT)) {
                return;
            }
            if (stand.isDead()) {
                return;
            }
            stand.setInvisible(Boolean.TRUE.equals(view.getBoolean("invisible")));
            stand.setBasePlate(Boolean.TRUE.equals(view.getBoolean("basePlate")));
            stand.setArms(Boolean.TRUE.equals(view.getBoolean("arms")));
            stand.setSmall(Boolean.TRUE.equals(view.getBoolean("small")));
            stand.setCanMove(Boolean.TRUE.equals(view.getBoolean("canMove")));
            stand.setGravity(Boolean.TRUE.equals(view.getBoolean("gravity")));
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(5L)).uses(1).build()))).build();
        ArrayList<ActionButton> actions = new ArrayList<ActionButton>();
        if (player.hasPermission("standin.change_type.armor_stand")) {
            ActionButton changeTypeButton = ActionButton.builder((Component)Component.text((String)"Change type")).action((DialogAction)DialogAction.customClick((view, audience) -> {
                if (!(audience instanceof Player)) {
                    return;
                }
                Player callbackPlayer = (Player)audience;
                if (playerId != callbackPlayer.getUniqueId()) {
                    return;
                }
                Entity entity = callbackPlayer.getWorld().getEntity(entityId);
                if (!(entity instanceof ArmorStand)) {
                    return;
                }
                ArmorStand stand = (ArmorStand)entity;
                Dialog dialog = this.conversionDialog(callbackPlayer, stand);
                if (dialog == null) {
                    return;
                }
                callbackPlayer.showDialog((DialogLike)dialog);
            }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(5L)).uses(1).build()))).build();
            actions.add(changeTypeButton);
        }
        actions.add(saveButton);
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)Component.text((String)"Armor Stand Editor")).inputs(inputs).build()).type((DialogType)DialogType.multiAction((List)actions, (ActionButton)ActionButton.builder((Component)Component.text((String)"Cancel")).build(), (int)1)));
    }
}

