/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin.entity;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import me.youhavetrouble.standin.converter.EntityConverter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityHandler<E extends Entity> {
    public final Class<E> clazz;
    private final Set<EntityConverter<E, ?>> possibleConverters = new HashSet();

    public EntityHandler(Class<E> clazz) {
        this.clazz = clazz;
    }

    public final Set<Class<? extends Entity>> getPossibleConversions() {
        HashSet<Class> classes = new HashSet<Class>();
        for (EntityConverter<E, ?> converter : this.possibleConverters) {
            classes.add(converter.entityTo().getEntityClass());
        }
        return Collections.unmodifiableSet(classes);
    }

    public final void addConverter(EntityConverter<E, ?> converter) {
        this.possibleConverters.add(converter);
    }

    @Nullable
    public final Dialog conversionDialog(@NotNull Player player, E entity) {
        if (entity.isDead()) {
            return null;
        }
        if (this.possibleConverters.isEmpty()) {
            return null;
        }
        if (!this.canUseAction(player, entity, EntityAction.CHANGE_TYPE)) {
            return null;
        }
        UUID entityId = entity.getUniqueId();
        UUID playerId = player.getUniqueId();
        Class entityClass = entity.getClass();
        ArrayList<SingleOptionDialogInput.OptionEntry> entityEntries = new ArrayList<SingleOptionDialogInput.OptionEntry>();
        entityEntries.add(SingleOptionDialogInput.OptionEntry.create((String)entity.getType().toString(), (Component)Component.translatable((String)entity.getType().translationKey(), (String)entity.getType().toString()), (boolean)true));
        for (EntityConverter<E, ?> converter : this.possibleConverters) {
            entityEntries.add(SingleOptionDialogInput.OptionEntry.create((String)converter.entityTo().toString(), (Component)Component.translatable((String)converter.entityTo().translationKey()), (boolean)false));
        }
        List<SingleOptionDialogInput> inputs = List.of(DialogInput.singleOption((String)"entity_type", (Component)Component.text((String)"New entity type"), entityEntries).build());
        ActionButton saveButton = ActionButton.builder((Component)Component.text((String)"Change type")).action((DialogAction)DialogAction.customClick((view, audience) -> {
            if (!(audience instanceof Player)) {
                return;
            }
            Player callbackPlayer = (Player)audience;
            if (playerId != callbackPlayer.getUniqueId()) {
                return;
            }
            Entity callbackEntity = callbackPlayer.getWorld().getEntity(entityId);
            if (callbackEntity == null || callbackEntity.isDead()) {
                return;
            }
            if (!callbackEntity.getClass().equals(entityClass)) {
                return;
            }
            Entity existing = callbackEntity;
            if (!this.canUseAction(callbackPlayer, existing, EntityAction.CHANGE_TYPE)) {
                return;
            }
            String newEntityType = view.getText("entity_type");
            if (newEntityType == null) {
                return;
            }
            if (newEntityType.equals(existing.getClass().getName())) {
                return;
            }
            EntityConverter<E, ?> foundConverter = null;
            for (EntityConverter<E, ?> converter : this.possibleConverters) {
                if (!newEntityType.equals(converter.entityTo().toString())) continue;
                foundConverter = converter;
                break;
            }
            if (foundConverter == null) {
                return;
            }
            Object converted = foundConverter.spawn(existing);
            if (converted == null) {
                return;
            }
            existing.remove();
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofHours(1L)).uses(1).build()))).build();
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)Component.text((String)"Entity Conversion")).body(List.of(DialogBody.plainMessage((Component)Component.text((String)"Some settings might not persist between changing entity type").color((TextColor)NamedTextColor.RED)))).inputs(inputs).build()).type((DialogType)DialogType.confirmation((ActionButton)saveButton, (ActionButton)ActionButton.builder((Component)Component.text((String)"Cancel")).build())));
    }

    public boolean canUseAction(@NotNull Player player, E entity, EntityAction action) {
        AttributeInstance rangeInstance = player.getAttribute(Attribute.ENTITY_INTERACTION_RANGE);
        if (rangeInstance == null) {
            return false;
        }
        double range = rangeInstance.getValue() + 0.5;
        if (player.getWorld() != entity.getWorld() || player.getLocation().distanceSquared(entity.getLocation()) > range * range) {
            return false;
        }
        String entityTypeName = entity.getType().toString().toLowerCase(Locale.ENGLISH);
        return switch (action.ordinal()) {
            case 0 -> player.hasPermission("standin.edit." + entityTypeName);
            case 1 -> player.hasPermission("standin.change_type." + entityTypeName);
            default -> false;
        };
    }

    public Dialog editDialog(@NotNull Player player, E entity) {
        return null;
    }

    public static enum EntityAction {
        EDIT,
        CHANGE_TYPE;

    }
}

