/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.standin.entity;

import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.youhavetrouble.standin.converter.MannequinToArmorStandConverter;
import me.youhavetrouble.standin.entity.EntityHandler;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MannequinHandler
extends EntityHandler<Mannequin> {
    public MannequinHandler() {
        super(Mannequin.class);
        this.addConverter(new MannequinToArmorStandConverter());
    }

    @Override
    public Dialog editDialog(@NotNull Player player, Mannequin mannequin) {
        if (mannequin == null || mannequin.isDead()) {
            return null;
        }
        if (!this.canUseAction(player, mannequin, EntityHandler.EntityAction.EDIT)) {
            return null;
        }
        UUID entityId = mannequin.getUniqueId();
        UUID playerId = player.getUniqueId();
        ArrayList<Object> inputs = new ArrayList<Object>();
        String name = "";
        Component customName = mannequin.customName();
        if (customName != null) {
            name = PlainTextComponentSerializer.plainText().serialize(customName);
        }
        inputs.add(DialogInput.text((String)"name", (Component)Component.text((String)"Name")).initial(name).build());
        String profileName = "";
        if (mannequin.getProfile().name() != null) {
            profileName = mannequin.getProfile().name();
        }
        inputs.add(DialogInput.text((String)"profile", (Component)Component.text((String)"Skin Profile (Mojang Username)")).initial(profileName).build());
        inputs.add(DialogInput.bool((String)"immovable", (Component)Component.text((String)"Immovable")).initial(mannequin.isImmovable()).build());
        inputs.add(DialogInput.bool((String)"invulnerable", (Component)Component.text((String)"Invulnerable")).initial(mannequin.isInvulnerable()).build());
        inputs.add(DialogInput.bool((String)"gravity", (Component)Component.text((String)"Gravity")).initial(mannequin.hasGravity()).build());
        ArrayList<ActionButton> actions = new ArrayList<ActionButton>();
        ActionButton saveButton = ActionButton.builder((Component)Component.text((String)"Save")).action((DialogAction)DialogAction.customClick((view, audience) -> {
            if (!(audience instanceof Player)) {
                return;
            }
            Player callbackPlayer = (Player)audience;
            if (playerId != callbackPlayer.getUniqueId()) {
                return;
            }
            Entity entity = callbackPlayer.getWorld().getEntity(entityId);
            if (!(entity instanceof Mannequin)) {
                return;
            }
            Mannequin mann = (Mannequin)entity;
            if (!this.canUseAction(callbackPlayer, mann, EntityHandler.EntityAction.EDIT)) {
                return;
            }
            if (mann.isDead()) {
                return;
            }
            String newName = view.getText("name");
            Component displayName = null;
            if (newName != null) {
                displayName = MiniMessage.miniMessage().deserialize((Object)newName);
            }
            mann.customName(displayName);
            mann.setImmovable(Boolean.TRUE.equals(view.getBoolean("immovable")));
            mann.setVelocity(mann.getVelocity().zero());
            mann.setGravity(Boolean.TRUE.equals(view.getBoolean("gravity")));
            mann.setInvulnerable(Boolean.TRUE.equals(view.getBoolean("invulnerable")));
            try {
                String newProfileName = view.getText("profile");
                if (newProfileName == null || newProfileName.isBlank()) {
                    newProfileName = null;
                }
                mann.setProfile((ResolvableProfile)ResolvableProfile.resolvableProfile().name(newProfileName).build());
            }
            catch (IllegalArgumentException e) {
                callbackPlayer.sendRichMessage("<red>Profile name not updated: invalid username.");
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(5L)).uses(1).build()))).build();
        actions.add(saveButton);
        if (player.hasPermission("standin.change_type.armor_stand")) {
            ActionButton changeTypeButton = ActionButton.builder((Component)Component.text((String)"Change type")).action((DialogAction)DialogAction.customClick((view, audience) -> {
                if (!(audience instanceof Player)) {
                    return;
                }
                Player callbackPlayer = (Player)audience;
                if (playerId != callbackPlayer.getUniqueId()) {
                    return;
                }
                Entity entity = callbackPlayer.getWorld().getEntity(entityId);
                if (!(entity instanceof Mannequin)) {
                    return;
                }
                Mannequin mann = (Mannequin)entity;
                Dialog dialog = this.conversionDialog(callbackPlayer, mann);
                if (dialog == null) {
                    return;
                }
                callbackPlayer.showDialog((DialogLike)dialog);
            }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().lifetime((TemporalAmount)Duration.ofMinutes(5L)).uses(1).build()))).build();
            actions.add(changeTypeButton);
        }
        return Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)Component.text((String)"Armor Stand Editor")).inputs(inputs).build()).type((DialogType)DialogType.multiAction((List)actions, (ActionButton)ActionButton.builder((Component)Component.text((String)"Cancel")).build(), (int)1)));
    }
}

