/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MoreBodySubscribers;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.spi.BodyAdapterFinder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface BodyAdapter {
    public boolean isCompatibleWith(MediaType var1);

    public boolean supportsType(TypeRef<?> var1);

    private static <A extends BodyAdapter> Optional<A> lookupAdapter(List<A> installed, TypeRef<?> type, @Nullable MediaType mediaType) {
        return installed.stream().filter(a -> a.supportsType(type) && (mediaType == null || a.isCompatibleWith(mediaType))).findFirst();
    }

    public static interface Decoder
    extends BodyAdapter {
        public <T> HttpResponse.BodySubscriber<T> toObject(TypeRef<T> var1, @Nullable MediaType var2);

        default public <T> HttpResponse.BodySubscriber<Supplier<T>> toDeferredObject(TypeRef<T> type, @Nullable MediaType mediaType) {
            return MoreBodySubscribers.fromAsyncSubscriber(this.toObject(type, mediaType), s2 -> CompletableFuture.completedStage(() -> s2.getBody().toCompletableFuture().join()));
        }

        public static List<Decoder> installed() {
            return BodyAdapterFinder.findInstalledDecoders();
        }

        public static Optional<Decoder> getDecoder(TypeRef<?> type, @Nullable MediaType mediaType) {
            return BodyAdapter.lookupAdapter(Decoder.installed(), type, mediaType);
        }
    }

    public static interface Encoder
    extends BodyAdapter {
        public HttpRequest.BodyPublisher toBody(Object var1, @Nullable MediaType var2);

        public static List<Encoder> installed() {
            return BodyAdapterFinder.findInstalledEncoders();
        }

        public static Optional<Encoder> getEncoder(TypeRef<?> type, @Nullable MediaType mediaType) {
            return BodyAdapter.lookupAdapter(Encoder.installed(), type, mediaType);
        }
    }
}

