/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.cache.DateUtils;
import com.github.mizosoft.methanol.internal.text.HeaderValueTokenizer;
import java.net.http.HttpHeaders;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CacheControl {
    private static final CacheControl EMPTY = new Builder().build();
    private final Optional<Duration> maxAge;
    private final Optional<Duration> minFresh;
    private final Optional<Duration> sMaxAge;
    private final Optional<Duration> maxStale;
    private final Optional<Duration> staleWhileRevalidate;
    private final Optional<Duration> staleIfError;
    private final boolean anyMaxStale;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final boolean isPublic;
    private final boolean isPrivate;
    private final boolean onlyIfCached;
    private final boolean mustRevalidate;
    private final boolean proxyRevalidate;
    private final Set<String> noCacheFields;
    private final Set<String> noStoreFields;
    private final Set<String> privateFields;
    private @MonotonicNonNull Map<String, String> directives;
    private final Map<String, String> unrecognizedAddedDirectives;
    private @MonotonicNonNull String cachedToString;

    private CacheControl(Builder builder) {
        this.maxAge = Optional.ofNullable(builder.maxAge);
        this.minFresh = Optional.ofNullable(builder.minFresh);
        this.sMaxAge = Optional.ofNullable(builder.sMaxAge);
        this.maxStale = Optional.ofNullable(builder.maxStale);
        this.staleWhileRevalidate = Optional.ofNullable(builder.staleWhileRevalidate);
        this.staleIfError = Optional.ofNullable(builder.staleIfError);
        this.anyMaxStale = builder.anyMaxStale;
        this.noCache = builder.noCache;
        this.noStore = builder.noStore;
        this.noTransform = builder.noTransform;
        this.isPublic = builder.isPublic;
        this.isPrivate = builder.isPrivate;
        this.onlyIfCached = builder.onlyIfCached;
        this.mustRevalidate = builder.mustRevalidate;
        this.proxyRevalidate = builder.proxyRevalidate;
        this.noCacheFields = builder.noCacheFields;
        this.noStoreFields = builder.noStoreFields;
        this.privateFields = builder.privateFields;
        if (builder.parsedDirectives != null) {
            this.directives = Collections.unmodifiableMap(builder.parsedDirectives);
            this.unrecognizedAddedDirectives = Map.of();
        } else {
            this.unrecognizedAddedDirectives = Map.copyOf(builder.unrecognizedDirectives);
        }
    }

    public Map<String, String> directives() {
        Map<String, String> result = this.directives;
        if (result == null) {
            this.directives = result = this.computeDirectives();
        }
        return result;
    }

    private Map<String, String> computeDirectives() {
        LinkedHashMap<String, String> directives = new LinkedHashMap<String, String>();
        this.maxAge.ifPresent(maxAge -> directives.put("max-age", Long.toString(maxAge.toSeconds())));
        this.minFresh.ifPresent(minFresh -> directives.put("min-fresh", Long.toString(minFresh.toSeconds())));
        this.sMaxAge.ifPresent(sMaxAge -> directives.put("s-maxage", Long.toString(sMaxAge.toSeconds())));
        this.maxStale.ifPresentOrElse(maxStale -> directives.put("max-stale", Long.toString(maxStale.toSeconds())), () -> {
            if (this.anyMaxStale) {
                directives.put("max-stale", "");
            }
        });
        this.staleWhileRevalidate.ifPresent(staleWhileRevalidate -> directives.put("stale-while-revalidate", Long.toString(staleWhileRevalidate.toSeconds())));
        this.staleIfError.ifPresent(staleIfError -> directives.put("stale-if-error", Long.toString(staleIfError.toSeconds())));
        if (this.noCache) {
            directives.put("no-cache", CacheControl.joinFields(this.noCacheFields));
        }
        if (this.noStore) {
            directives.put("no-store", CacheControl.joinFields(this.noStoreFields));
        }
        if (this.noTransform) {
            directives.put("no-transform", "");
        }
        if (this.isPublic) {
            directives.put("public", "");
        }
        if (this.isPrivate) {
            directives.put("private", CacheControl.joinFields(this.privateFields));
        }
        if (this.onlyIfCached) {
            directives.put("only-if-cached", "");
        }
        if (this.mustRevalidate) {
            directives.put("must-revalidate", "");
        }
        if (this.proxyRevalidate) {
            directives.put("proxy-revalidate", "");
        }
        directives.putAll(this.unrecognizedAddedDirectives);
        return Collections.unmodifiableMap(directives);
    }

    public Optional<Duration> maxAge() {
        return this.maxAge;
    }

    public Optional<Duration> sMaxAge() {
        return this.sMaxAge;
    }

    public Optional<Duration> minFresh() {
        return this.minFresh;
    }

    public Optional<Duration> maxStale() {
        return this.maxStale;
    }

    public boolean anyMaxStale() {
        return this.anyMaxStale;
    }

    public Optional<Duration> staleWhileRevalidate() {
        return this.staleWhileRevalidate;
    }

    public Optional<Duration> staleIfError() {
        return this.staleIfError;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public Set<String> noCacheFields() {
        return this.noCacheFields;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public Set<String> noStoreFields() {
        return this.noStoreFields;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public Set<String> privateFields() {
        return this.privateFields;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean proxyRevalidate() {
        return this.proxyRevalidate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof CacheControl && this.directives().equals(((CacheControl)obj).directives());
    }

    public int hashCode() {
        return 31 * this.directives().hashCode();
    }

    public String toString() {
        String result = this.cachedToString;
        if (result == null) {
            this.cachedToString = result = this.computeToString();
        }
        return result;
    }

    private String computeToString() {
        return this.directives().entrySet().stream().map(entry -> ((String)entry.getValue()).isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "=" + Utils.escapeAndQuoteValueIfNeeded((String)entry.getValue())).collect(Collectors.joining(", "));
    }

    public static CacheControl parse(String value2) {
        return CacheControl.parse(List.of(value2));
    }

    public static CacheControl parse(List<String> values) {
        Objects.requireNonNull(values);
        if (values.isEmpty()) {
            return CacheControl.empty();
        }
        try {
            LinkedHashMap<String, String> directives = new LinkedHashMap<String, String>();
            values.forEach(value2 -> CacheControl.parseDirectives(value2, directives));
            return new Builder(directives).build();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IllegalArgumentException(String.format("couldn't parse: '%s'", String.join((CharSequence)", ", values)), e);
        }
    }

    public static CacheControl parse(HttpHeaders headers) {
        return CacheControl.parse(headers.allValues("Cache-Control"));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static CacheControl empty() {
        return EMPTY;
    }

    private static void parseDirectives(String value2, Map<String, String> directives) {
        HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value2);
        tokenizer.consumeDelimiter(',', false);
        do {
            String normalizedDirective = tokenizer.nextToken().toLowerCase(Locale.ROOT);
            String argument = "";
            if (tokenizer.consumeCharIfPresent('=')) {
                argument = tokenizer.nextTokenOrQuotedString();
            }
            directives.put(normalizedDirective, argument);
        } while (tokenizer.consumeDelimiter(','));
    }

    private static String joinFields(Set<String> fields) {
        return fields.isEmpty() ? "" : String.join((CharSequence)", ", fields);
    }

    public static final class Builder {
        private static final Duration MAX_DELTA_SECONDS = Duration.ofSeconds(Integer.MAX_VALUE);
        final @Nullable Map<String, String> parsedDirectives;
        final Map<String, String> unrecognizedDirectives = new LinkedHashMap<String, String>();
        @MonotonicNonNull Duration maxAge;
        @MonotonicNonNull Duration minFresh;
        @MonotonicNonNull Duration sMaxAge;
        @Nullable Duration maxStale;
        @MonotonicNonNull Duration staleWhileRevalidate;
        @MonotonicNonNull Duration staleIfError;
        boolean anyMaxStale;
        boolean noCache;
        boolean noStore;
        boolean noTransform;
        boolean isPublic;
        boolean isPrivate;
        boolean onlyIfCached;
        boolean mustRevalidate;
        boolean proxyRevalidate;
        Set<String> noCacheFields = Set.of();
        Set<String> noStoreFields = Set.of();
        Set<String> privateFields = Set.of();

        Builder() {
            this.parsedDirectives = null;
        }

        Builder(Map<String, String> parsedDirectives) {
            this.parsedDirectives = Collections.unmodifiableMap(parsedDirectives);
            parsedDirectives.forEach(this::setNormalizedDirective);
        }

        public Builder directive(String directive) {
            return this.directive(directive, "");
        }

        public Builder directive(String directive, String argument) {
            Objects.requireNonNull(directive);
            Objects.requireNonNull(argument);
            Utils.validateToken(directive);
            Utils.validateHeaderValue(argument);
            this.setNormalizedDirective(directive.toLowerCase(Locale.ROOT), argument);
            return this;
        }

        private void setNormalizedDirective(String normalizedDirective, String argument) {
            if (!this.setStandardDirective(normalizedDirective, argument)) {
                this.unrecognizedDirectives.put(normalizedDirective, argument);
            }
        }

        public Builder maxAge(Duration maxAge) {
            Objects.requireNonNull(maxAge);
            this.maxAge = this.checkAndTruncateDeltaSeconds(maxAge);
            return this;
        }

        public Builder minFresh(Duration minFresh) {
            Objects.requireNonNull(minFresh);
            this.minFresh = this.checkAndTruncateDeltaSeconds(minFresh);
            return this;
        }

        public Builder maxStale(Duration maxStale) {
            Objects.requireNonNull(maxStale);
            this.maxStale = this.checkAndTruncateDeltaSeconds(maxStale);
            this.anyMaxStale = false;
            return this;
        }

        public Builder anyMaxStale() {
            this.maxStale = null;
            this.anyMaxStale = true;
            return this;
        }

        public Builder staleIfError(Duration staleIfError) {
            Objects.requireNonNull(staleIfError);
            this.staleIfError = this.checkAndTruncateDeltaSeconds(staleIfError);
            return this;
        }

        public Builder noCache() {
            this.noCache = true;
            return this;
        }

        public Builder noStore() {
            this.noStore = true;
            return this;
        }

        public Builder noTransform() {
            this.noTransform = true;
            return this;
        }

        public Builder onlyIfCached() {
            this.onlyIfCached = true;
            return this;
        }

        public CacheControl build() {
            return new CacheControl(this);
        }

        private Duration checkAndTruncateDeltaSeconds(Duration duration) {
            Utils.requireNonNegativeDuration(duration);
            Duration truncated = duration.truncatedTo(ChronoUnit.SECONDS);
            if (truncated.toSeconds() > Integer.MAX_VALUE) {
                truncated = MAX_DELTA_SECONDS;
            }
            return truncated;
        }

        private boolean mustHaveArgument(String normalizedDirective) {
            return "max-age".equals(normalizedDirective) || "min-fresh".equals(normalizedDirective) || "s-maxage".equals(normalizedDirective) || "stale-while-revalidate".equals(normalizedDirective) || "stale-if-error".equals(normalizedDirective);
        }

        private boolean setStandardDirective(String normalizedDirective, String argument) {
            Validate.requireArgument(!this.mustHaveArgument(normalizedDirective) || !argument.isEmpty(), "directive %s requires an argument", normalizedDirective);
            switch (normalizedDirective) {
                case "max-age": {
                    this.maxAge = DateUtils.toDeltaSeconds(argument);
                    break;
                }
                case "min-fresh": {
                    this.minFresh = DateUtils.toDeltaSeconds(argument);
                    break;
                }
                case "s-maxage": {
                    this.sMaxAge = DateUtils.toDeltaSeconds(argument);
                    break;
                }
                case "max-stale": {
                    if (argument.isEmpty()) {
                        this.anyMaxStale = true;
                        break;
                    }
                    this.maxStale = DateUtils.toDeltaSeconds(argument);
                    break;
                }
                case "stale-while-revalidate": {
                    this.staleWhileRevalidate = DateUtils.toDeltaSeconds(argument);
                    break;
                }
                case "stale-if-error": {
                    this.staleIfError = DateUtils.toDeltaSeconds(argument);
                    break;
                }
                case "no-cache": {
                    this.noCache = true;
                    if (argument.isEmpty()) break;
                    this.noCacheFields = Builder.parseFieldNames(argument);
                    break;
                }
                case "no-store": {
                    this.noStore = true;
                    if (argument.isEmpty()) break;
                    this.noStoreFields = Builder.parseFieldNames(argument);
                    break;
                }
                case "no-transform": {
                    this.noTransform = true;
                    break;
                }
                case "public": {
                    this.isPublic = true;
                    break;
                }
                case "private": {
                    this.isPrivate = true;
                    if (argument.isEmpty()) break;
                    this.privateFields = Builder.parseFieldNames(argument);
                    break;
                }
                case "only-if-cached": {
                    this.onlyIfCached = true;
                    break;
                }
                case "must-revalidate": {
                    this.mustRevalidate = true;
                    break;
                }
                case "proxy-revalidate": {
                    this.proxyRevalidate = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private static Set<String> parseFieldNames(String value2) {
            if (value2.isEmpty()) {
                return Set.of();
            }
            HeaderValueTokenizer tokenizer = new HeaderValueTokenizer(value2);
            LinkedHashSet<String> fields = new LinkedHashSet<String>();
            do {
                fields.add(tokenizer.nextToken().toLowerCase(Locale.ROOT));
            } while (tokenizer.consumeDelimiter(','));
            return Collections.unmodifiableSet(fields);
        }
    }
}

