/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.BodyDecoder;
import com.github.mizosoft.methanol.HttpCache;
import com.github.mizosoft.methanol.HttpHeadersTimeoutException;
import com.github.mizosoft.methanol.MimeBodyPublisher;
import com.github.mizosoft.methanol.MoreBodyHandlers;
import com.github.mizosoft.methanol.MutableRequest;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.cache.RedirectingInterceptor;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import com.github.mizosoft.methanol.internal.extensions.HeadersBuilder;
import com.github.mizosoft.methanol.internal.extensions.HttpResponsePublisher;
import com.github.mizosoft.methanol.internal.extensions.ResponseBuilder;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Methanol
extends HttpClient {
    private static final System.Logger logger = System.getLogger(Methanol.class.getName());
    private final HttpClient backend;
    private final HttpClient.Redirect redirectPolicy;
    private final HttpHeaders defaultHeaders;
    private final Optional<HttpCache> cache;
    private final Optional<String> userAgent;
    private final Optional<URI> baseUri;
    private final Optional<Duration> headersTimeout;
    private final Optional<Duration> requestTimeout;
    private final Optional<Duration> readTimeout;
    private final boolean autoAcceptEncoding;
    private final List<Interceptor> interceptors;
    private final List<Interceptor> backendInterceptors;
    private final List<Interceptor> chainInterceptors;

    private Methanol(BaseBuilder<?> builder) {
        this.backend = builder.buildBackend();
        this.redirectPolicy = Objects.requireNonNullElse(builder.redirectPolicy, this.backend.followRedirects());
        this.defaultHeaders = builder.headersBuilder.build();
        this.cache = Optional.ofNullable(builder.cache);
        this.userAgent = Optional.ofNullable(builder.userAgent);
        this.baseUri = Optional.ofNullable(builder.baseUri);
        this.headersTimeout = Optional.ofNullable(builder.headersTimeout);
        this.requestTimeout = Optional.ofNullable(builder.requestTimeout);
        this.readTimeout = Optional.ofNullable(builder.readTimeout);
        this.autoAcceptEncoding = builder.autoAcceptEncoding;
        this.interceptors = List.copyOf(builder.interceptors);
        this.backendInterceptors = List.copyOf(builder.backendInterceptors);
        ArrayList<Interceptor> chainInterceptors = new ArrayList<Interceptor>(this.interceptors);
        chainInterceptors.add(new RequestRewritingInterceptor(this.baseUri, this.defaultHeaders, this.requestTimeout, this.autoAcceptEncoding));
        if (this.autoAcceptEncoding) {
            chainInterceptors.add(AutoDecompressingInterceptor.INSTANCE);
        }
        this.headersTimeout.ifPresent(timeout2 -> chainInterceptors.add(new HeadersTimeoutInterceptor((Duration)timeout2, builder.headersTimeoutDelayer)));
        this.readTimeout.ifPresent(timeout2 -> chainInterceptors.add(new ReadTimeoutInterceptor((Duration)timeout2, builder.readTimeoutScheduler)));
        this.cache.ifPresent(cache -> {
            Executor executor = this.backend.executor().orElse(null);
            chainInterceptors.add(new RedirectingInterceptor(this.redirectPolicy, executor));
            chainInterceptors.add(cache.interceptor(executor));
        });
        chainInterceptors.addAll(this.backendInterceptors);
        this.chainInterceptors = Collections.unmodifiableList(chainInterceptors);
    }

    public <T> Flow.Publisher<HttpResponse<T>> exchange(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(bodyHandler, "bodyHandler");
        return new HttpResponsePublisher<T>(this, request, bodyHandler, null, this.executor().orElse(FlowSupport.SYNC_EXECUTOR));
    }

    public <T> Flow.Publisher<HttpResponse<T>> exchange(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, Function<HttpRequest, @Nullable HttpResponse.BodyHandler<T>> pushPromiseAcceptor) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(bodyHandler, "bodyHandler");
        Objects.requireNonNull(pushPromiseAcceptor, "pushPromiseAcceptor");
        return new HttpResponsePublisher<T>(this, request, bodyHandler, pushPromiseAcceptor, this.executor().orElse(FlowSupport.SYNC_EXECUTOR));
    }

    public HttpClient underlyingClient() {
        return this.backend;
    }

    public Optional<String> userAgent() {
        return this.userAgent;
    }

    public Optional<URI> baseUri() {
        return this.baseUri;
    }

    public Optional<Duration> requestTimeout() {
        return this.requestTimeout;
    }

    public Optional<Duration> headersTimeout() {
        return this.headersTimeout;
    }

    public Optional<Duration> readTimeout() {
        return this.readTimeout;
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public List<Interceptor> backendInterceptors() {
        return this.backendInterceptors;
    }

    @Deprecated(since="1.5.0")
    public List<Interceptor> postDecorationInterceptors() {
        return this.backendInterceptors;
    }

    public HttpHeaders defaultHeaders() {
        return this.defaultHeaders;
    }

    public boolean autoAcceptEncoding() {
        return this.autoAcceptEncoding;
    }

    public Optional<HttpCache> cache() {
        return this.cache;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return this.backend.cookieHandler();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return this.backend.connectTimeout();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.redirectPolicy;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return this.backend.proxy();
    }

    @Override
    public SSLContext sslContext() {
        return this.backend.sslContext();
    }

    @Override
    public SSLParameters sslParameters() {
        return this.backend.sslParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return this.backend.authenticator();
    }

    @Override
    public HttpClient.Version version() {
        return this.backend.version();
    }

    @Override
    public Optional<Executor> executor() {
        return this.backend.executor();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) throws IOException, InterruptedException {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(bodyHandler, "bodyHandler");
        return new InterceptorChain<T>(this.backend, bodyHandler, null, this.chainInterceptors).forward(request);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(bodyHandler, "bodyHandler");
        return new InterceptorChain<T>(this.backend, bodyHandler, null, this.chainInterceptors).forwardAsync(request);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(bodyHandler, "bodyHandler");
        return new InterceptorChain<T>(this.backend, bodyHandler, pushPromiseHandler, this.chainInterceptors).forwardAsync(request);
    }

    private static URI validateUri(URI uri) {
        String scheme = uri.getScheme();
        Validate.requireArgument(scheme != null, "uri has no scheme: %s", uri);
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        Validate.requireArgument("http".equals(scheme) || "https".equals(scheme), "unsupported scheme: %s", scheme);
        Validate.requireArgument(uri.getHost() != null, "uri has no host: %s", uri);
        return uri;
    }

    private static <T> HttpResponse.PushPromiseHandler<T> transformPushPromises(HttpResponse.PushPromiseHandler<T> pushPromiseHandler, UnaryOperator<HttpResponse.BodyHandler<T>> bodyHandlerTransformer, UnaryOperator<HttpResponse<T>> responseTransformer) {
        return (initialRequest, pushRequest, acceptor) -> pushPromiseHandler.applyPushPromise(initialRequest, pushRequest, acceptor.compose(bodyHandlerTransformer).andThen(future -> future.thenApply((Function)responseTransformer)));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static WithClientBuilder newBuilder(HttpClient backend) {
        return new WithClientBuilder(backend);
    }

    public static Methanol create() {
        return Methanol.newBuilder().build();
    }

    public static abstract class BaseBuilder<B extends BaseBuilder<B>> {
        final HeadersBuilder headersBuilder;
        @MonotonicNonNull String userAgent;
        @MonotonicNonNull URI baseUri;
        @MonotonicNonNull Duration requestTimeout;
        @MonotonicNonNull Duration headersTimeout;
        @MonotonicNonNull Delayer headersTimeoutDelayer;
        @MonotonicNonNull Duration readTimeout;
        @MonotonicNonNull ScheduledExecutorService readTimeoutScheduler;
        boolean autoAcceptEncoding = true;
        @MonotonicNonNull HttpCache cache;
        @MonotonicNonNull HttpClient.Redirect redirectPolicy;
        final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        final List<Interceptor> backendInterceptors = new ArrayList<Interceptor>();

        BaseBuilder() {
            this.headersBuilder = new HeadersBuilder();
        }

        public final B apply(Consumer<? super B> consumer) {
            consumer.accept(this.self());
            return this.self();
        }

        public B userAgent(String userAgent) {
            Objects.requireNonNull(userAgent);
            Utils.validateHeaderValue(userAgent);
            this.userAgent = userAgent;
            this.headersBuilder.set("User-Agent", userAgent);
            return this.self();
        }

        public B baseUri(String uri) {
            return this.baseUri(URI.create(uri));
        }

        public B baseUri(URI uri) {
            Objects.requireNonNull(uri);
            this.baseUri = Methanol.validateUri(uri);
            return this.self();
        }

        public B defaultHeader(String name, String value2) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value2);
            Utils.validateHeader(name, value2);
            if ("User-Agent".equalsIgnoreCase(name)) {
                this.userAgent = value2;
            }
            this.headersBuilder.add(name, value2);
            return this.self();
        }

        public B defaultHeaders(String ... headers) {
            Objects.requireNonNull(headers, "headers");
            int len = headers.length;
            Validate.requireArgument(len > 0 && len % 2 == 0, "illegal number of headers: %d", len);
            for (int i = 0; i < len; i += 2) {
                this.defaultHeader(headers[i], headers[i + 1]);
            }
            return this.self();
        }

        public B requestTimeout(Duration requestTimeout) {
            Objects.requireNonNull(requestTimeout);
            Utils.requirePositiveDuration(requestTimeout);
            this.requestTimeout = requestTimeout;
            return this.self();
        }

        public B headersTimeout(Duration headersTimeout) {
            return this.headersTimeout(headersTimeout, Delayer.systemDelayer());
        }

        public B headersTimeout(Duration headersTimeout, ScheduledExecutorService scheduler) {
            return this.headersTimeout(headersTimeout, Delayer.of(scheduler));
        }

        B headersTimeout(Duration headersTimeout, Delayer delayer) {
            Objects.requireNonNull(headersTimeout);
            Objects.requireNonNull(delayer);
            Utils.requirePositiveDuration(headersTimeout);
            this.headersTimeout = headersTimeout;
            this.headersTimeoutDelayer = delayer;
            return this.self();
        }

        public B readTimeout(Duration readTimeout) {
            Objects.requireNonNull(readTimeout);
            Utils.requirePositiveDuration(readTimeout);
            this.readTimeout = readTimeout;
            return this.self();
        }

        public B readTimeout(Duration readTimeout, ScheduledExecutorService scheduler) {
            Objects.requireNonNull(readTimeout);
            Objects.requireNonNull(scheduler);
            Utils.requirePositiveDuration(readTimeout);
            this.readTimeout = readTimeout;
            this.readTimeoutScheduler = scheduler;
            return this.self();
        }

        public B autoAcceptEncoding(boolean autoAcceptEncoding) {
            this.autoAcceptEncoding = autoAcceptEncoding;
            return this.self();
        }

        public B interceptor(Interceptor interceptor) {
            Objects.requireNonNull(interceptor);
            this.interceptors.add(interceptor);
            return this.self();
        }

        public B backendInterceptor(Interceptor interceptor) {
            Objects.requireNonNull(interceptor);
            this.backendInterceptors.add(interceptor);
            return this.self();
        }

        @Deprecated(since="1.5.0")
        public B postDecorationInterceptor(Interceptor interceptor) {
            return this.backendInterceptor(interceptor);
        }

        public Methanol build() {
            return new Methanol(this);
        }

        abstract B self();

        abstract HttpClient buildBackend();
    }

    private static final class RequestRewritingInterceptor
    implements Interceptor {
        private final Optional<URI> baseUri;
        private final Optional<Duration> requestTimeout;
        private final HttpHeaders defaultHeaders;
        private final boolean autoAcceptEncoding;

        RequestRewritingInterceptor(Optional<URI> baseUri, HttpHeaders defaultHeaders, Optional<Duration> requestTimeout, boolean autoAcceptEncoding) {
            this.baseUri = baseUri;
            this.requestTimeout = requestTimeout;
            this.defaultHeaders = defaultHeaders;
            this.autoAcceptEncoding = autoAcceptEncoding;
        }

        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            return chain.forward(this.rewriteRequest(request));
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            return chain.forwardAsync(this.rewriteRequest(request));
        }

        private HttpRequest rewriteRequest(HttpRequest request) {
            Set<String> supportedEncodings;
            MutableRequest rewrittenRequest = MutableRequest.copyOf(request);
            this.baseUri.map(baseUri -> baseUri.resolve(request.uri())).ifPresent(rewrittenRequest::uri);
            Methanol.validateUri(rewrittenRequest.uri());
            Map<String, List<String>> originalHeadersMap = request.headers().map();
            Map<String, List<String>> defaultHeadersMap = this.defaultHeaders.map();
            defaultHeadersMap.forEach((name, values) -> {
                if (!originalHeadersMap.containsKey(name)) {
                    values.forEach(value2 -> rewrittenRequest.header((String)name, (String)value2));
                }
            });
            if (this.autoAcceptEncoding && !originalHeadersMap.containsKey("Accept-Encoding") && !defaultHeadersMap.containsKey("Accept-Encoding") && !(supportedEncodings = BodyDecoder.Factory.installedBindings().keySet()).isEmpty()) {
                rewrittenRequest.header("Accept-Encoding", String.join((CharSequence)", ", supportedEncodings));
            }
            request.bodyPublisher().filter(MimeBodyPublisher.class::isInstance).map(body -> ((MimeBodyPublisher)body).mediaType()).ifPresent(mediaType -> rewrittenRequest.setHeader("Content-Type", mediaType.toString()));
            if (request.timeout().isEmpty()) {
                this.requestTimeout.ifPresent(rewrittenRequest::timeout);
            }
            return rewrittenRequest.toImmutableRequest();
        }
    }

    private static enum AutoDecompressingInterceptor implements Interceptor
    {
        INSTANCE;


        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            return AutoDecompressingInterceptor.stripContentEncoding(AutoDecompressingInterceptor.decoding(request, chain).forward(request));
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            return AutoDecompressingInterceptor.decoding(request, chain).forwardAsync(request).thenApply(AutoDecompressingInterceptor::stripContentEncoding);
        }

        private static <T> Interceptor.Chain<T> decoding(HttpRequest request, Interceptor.Chain<T> chain) {
            if ("HEAD".equalsIgnoreCase(request.method())) {
                return chain;
            }
            return chain.with(MoreBodyHandlers.decoding(chain.bodyHandler()), chain.pushPromiseHandler().map(handler -> Methanol.transformPushPromises(handler, MoreBodyHandlers::decoding, AutoDecompressingInterceptor::stripContentEncoding)).orElse(null));
        }

        private static <T> HttpResponse<T> stripContentEncoding(HttpResponse<T> response) {
            if ("HEAD".equalsIgnoreCase(response.request().method()) || !response.headers().map().containsKey("Content-Encoding")) {
                return response;
            }
            return ResponseBuilder.newBuilder(response).removeHeader("Content-Encoding").removeHeader("Content-Length").build();
        }
    }

    private static final class InterceptorChain<T>
    implements Interceptor.Chain<T> {
        private final HttpClient backend;
        private final HttpResponse.BodyHandler<T> bodyHandler;
        private final @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler;
        private final List<Interceptor> interceptors;
        private final int currentInterceptorIndex;

        InterceptorChain(HttpClient backend, HttpResponse.BodyHandler<T> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler, List<Interceptor> interceptors) {
            this(backend, bodyHandler, pushPromiseHandler, interceptors, 0);
        }

        private InterceptorChain(HttpClient backend, HttpResponse.BodyHandler<T> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler, List<Interceptor> interceptors, int currentInterceptorIndex) {
            this.backend = backend;
            this.bodyHandler = bodyHandler;
            this.pushPromiseHandler = pushPromiseHandler;
            this.interceptors = interceptors;
            this.currentInterceptorIndex = currentInterceptorIndex;
        }

        @Override
        public HttpResponse.BodyHandler<T> bodyHandler() {
            return this.bodyHandler;
        }

        @Override
        public Optional<HttpResponse.PushPromiseHandler<T>> pushPromiseHandler() {
            return Optional.ofNullable(this.pushPromiseHandler);
        }

        @Override
        public Interceptor.Chain<T> withBodyHandler(HttpResponse.BodyHandler<T> bodyHandler) {
            Objects.requireNonNull(bodyHandler);
            return new InterceptorChain<T>(this.backend, bodyHandler, this.pushPromiseHandler, this.interceptors, this.currentInterceptorIndex);
        }

        @Override
        public Interceptor.Chain<T> withPushPromiseHandler(@Nullable HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
            return new InterceptorChain<T>(this.backend, this.bodyHandler, pushPromiseHandler, this.interceptors, this.currentInterceptorIndex);
        }

        @Override
        public <U> Interceptor.Chain<U> with(HttpResponse.BodyHandler<U> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<U> pushPromiseHandler) {
            Objects.requireNonNull(bodyHandler);
            return new InterceptorChain<U>(this.backend, bodyHandler, pushPromiseHandler, this.interceptors, this.currentInterceptorIndex);
        }

        @Override
        public HttpResponse<T> forward(HttpRequest request) throws IOException, InterruptedException {
            Objects.requireNonNull(request);
            if (this.currentInterceptorIndex >= this.interceptors.size()) {
                return this.backend.send(request, this.bodyHandler);
            }
            Interceptor interceptor = this.interceptors.get(this.currentInterceptorIndex);
            return Objects.requireNonNull(interceptor.intercept(request, this.nextInterceptorChain()), () -> interceptor + "::intercept returned a null response");
        }

        @Override
        public CompletableFuture<HttpResponse<T>> forwardAsync(HttpRequest request) {
            Objects.requireNonNull(request);
            if (this.currentInterceptorIndex >= this.interceptors.size()) {
                return this.backend.sendAsync(request, this.bodyHandler, this.pushPromiseHandler);
            }
            Interceptor interceptor = this.interceptors.get(this.currentInterceptorIndex);
            return interceptor.interceptAsync(request, this.nextInterceptorChain()).thenApply(res -> Objects.requireNonNull(res, () -> interceptor + "::interceptAsync completed with a null response"));
        }

        private InterceptorChain<T> nextInterceptorChain() {
            return new InterceptorChain<T>(this.backend, this.bodyHandler, this.pushPromiseHandler, this.interceptors, this.currentInterceptorIndex + 1);
        }
    }

    public static final class Builder
    extends BaseBuilder<Builder>
    implements HttpClient.Builder {
        private final HttpClient.Builder backendBuilder = HttpClient.newBuilder();

        Builder() {
        }

        public Builder cache(HttpCache cache) {
            this.cache = Objects.requireNonNull(cache);
            return this;
        }

        @Override
        public Builder cookieHandler(CookieHandler cookieHandler) {
            this.backendBuilder.cookieHandler(cookieHandler);
            return this;
        }

        @Override
        public Builder connectTimeout(Duration duration) {
            this.backendBuilder.connectTimeout(duration);
            return this;
        }

        @Override
        public Builder sslContext(SSLContext sslContext) {
            this.backendBuilder.sslContext(sslContext);
            return this;
        }

        @Override
        public Builder sslParameters(SSLParameters sslParameters) {
            this.backendBuilder.sslParameters(sslParameters);
            return this;
        }

        @Override
        public Builder executor(Executor executor) {
            this.backendBuilder.executor(executor);
            return this;
        }

        @Override
        public Builder followRedirects(HttpClient.Redirect policy) {
            this.redirectPolicy = Objects.requireNonNull(policy);
            return this;
        }

        @Override
        public Builder version(HttpClient.Version version) {
            this.backendBuilder.version(version);
            return this;
        }

        @Override
        public Builder priority(int priority) {
            this.backendBuilder.priority(priority);
            return this;
        }

        @Override
        public Builder proxy(ProxySelector proxySelector) {
            this.backendBuilder.proxy(proxySelector);
            return this;
        }

        @Override
        public Builder authenticator(Authenticator authenticator) {
            this.backendBuilder.authenticator(authenticator);
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        HttpClient buildBackend() {
            if (this.cache == null && this.redirectPolicy != null) {
                this.backendBuilder.followRedirects(this.redirectPolicy);
            }
            return this.backendBuilder.build();
        }
    }

    public static final class WithClientBuilder
    extends BaseBuilder<WithClientBuilder> {
        private final HttpClient backend;

        WithClientBuilder(HttpClient backend) {
            this.backend = Objects.requireNonNull(backend);
        }

        @Override
        WithClientBuilder self() {
            return this;
        }

        @Override
        HttpClient buildBackend() {
            return this.backend;
        }
    }

    public static interface Interceptor {
        public <T> HttpResponse<T> intercept(HttpRequest var1, Chain<T> var2) throws IOException, InterruptedException;

        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest var1, Chain<T> var2);

        public static Interceptor create(final UnaryOperator<HttpRequest> operator) {
            Objects.requireNonNull(operator);
            return new Interceptor(){

                @Override
                public <T> HttpResponse<T> intercept(HttpRequest request, Chain<T> chain) throws IOException, InterruptedException {
                    return chain.forward((HttpRequest)operator.apply(request));
                }

                @Override
                public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Chain<T> chain) {
                    return chain.forwardAsync((HttpRequest)operator.apply(request));
                }
            };
        }

        public static interface Chain<T> {
            public HttpResponse.BodyHandler<T> bodyHandler();

            public Optional<HttpResponse.PushPromiseHandler<T>> pushPromiseHandler();

            public Chain<T> withBodyHandler(HttpResponse.BodyHandler<T> var1);

            public Chain<T> withPushPromiseHandler(@Nullable HttpResponse.PushPromiseHandler<T> var1);

            default public <U> Chain<U> with(HttpResponse.BodyHandler<U> bodyHandler, @Nullable HttpResponse.PushPromiseHandler<U> pushPromiseHandler) {
                throw new UnsupportedOperationException();
            }

            public HttpResponse<T> forward(HttpRequest var1) throws IOException, InterruptedException;

            public CompletableFuture<HttpResponse<T>> forwardAsync(HttpRequest var1);
        }
    }

    private static final class ReadTimeoutInterceptor
    implements Interceptor {
        private final Duration readTimeout;
        private final @Nullable ScheduledExecutorService readTimeoutScheduler;

        ReadTimeoutInterceptor(Duration readTimeout, @Nullable ScheduledExecutorService readTimeoutScheduler) {
            this.readTimeout = readTimeout;
            this.readTimeoutScheduler = readTimeoutScheduler;
        }

        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            return this.withReadTimeout(chain).forward(request);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            return this.withReadTimeout(chain).forwardAsync(request);
        }

        private <T> Interceptor.Chain<T> withReadTimeout(Interceptor.Chain<T> chain) {
            return chain.with(this.withReadTimeout(chain.bodyHandler()), chain.pushPromiseHandler().map(handler -> Methanol.transformPushPromises(handler, this::withReadTimeout, UnaryOperator.identity())).orElse(null));
        }

        private <T> HttpResponse.BodyHandler<T> withReadTimeout(HttpResponse.BodyHandler<T> bodyHandler) {
            return this.readTimeoutScheduler != null ? MoreBodyHandlers.withReadTimeout(bodyHandler, this.readTimeout, this.readTimeoutScheduler) : MoreBodyHandlers.withReadTimeout(bodyHandler, this.readTimeout);
        }
    }

    private static final class HeadersTimeoutInterceptor
    implements Interceptor {
        private final Duration headersTimeout;
        private final Delayer delayer;

        HeadersTimeoutInterceptor(Duration headersTimeout, Delayer delayer) {
            this.headersTimeout = headersTimeout;
            this.delayer = delayer;
        }

        @Override
        public <T> HttpResponse<T> intercept(HttpRequest request, Interceptor.Chain<T> chain) throws IOException, InterruptedException {
            return Utils.block(this.interceptAsync(request, chain));
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Interceptor.Chain<T> chain) {
            TimeoutTask timeoutTask = new TimeoutTask();
            Future<Void> timeoutFuture = this.delayer.delay(timeoutTask::onTimeout, this.headersTimeout, FlowSupport.SYNC_EXECUTOR);
            timeoutTask.whenCancelled(() -> timeoutFuture.cancel(false));
            CompletableFuture responseFuture = this.withHeadersTimeout(chain, timeoutTask).forwardAsync(request);
            CompletableFuture responseFutureCopy = responseFuture.copy();
            timeoutTask.whenTimedOut(() -> {
                responseFutureCopy.completeExceptionally(new HttpHeadersTimeoutException("couldn't receive headers on time"));
                responseFuture.cancel(true);
            });
            return responseFutureCopy;
        }

        private <T> Interceptor.Chain<T> withHeadersTimeout(Interceptor.Chain<T> chain, TimeoutTask timeoutTask) {
            return chain.withBodyHandler(responseInfo -> timeoutTask.cancel() ? chain.bodyHandler().apply(responseInfo) : new TimedOutSubscriber());
        }

        private static final class TimeoutTask {
            private final CompletableFuture<Void> onTimeout = new CompletableFuture();

            TimeoutTask() {
            }

            void onTimeout() {
                this.onTimeout.complete(null);
            }

            void whenTimedOut(Runnable action) {
                this.onTimeout.thenRun(action);
            }

            void whenCancelled(Runnable action) {
                this.onTimeout.whenComplete((__, e) -> {
                    if (e instanceof CancellationException) {
                        action.run();
                    }
                });
            }

            boolean cancel() {
                return this.onTimeout.cancel(false);
            }
        }

        private static final class TimedOutSubscriber<T>
        implements HttpResponse.BodySubscriber<T> {
            TimedOutSubscriber() {
            }

            @Override
            public CompletionStage<T> getBody() {
                return CompletableFuture.failedFuture(new HttpHeadersTimeoutException("couldn't receive headers ont time"));
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                Objects.requireNonNull(subscription);
                subscription.cancel();
            }

            @Override
            public void onNext(List<ByteBuffer> item) {
                Objects.requireNonNull(item);
            }

            @Override
            public void onError(Throwable throwable) {
                Objects.requireNonNull(throwable);
                logger.log(System.Logger.Level.WARNING, "exception received after headers timeout", throwable);
            }

            @Override
            public void onComplete() {
            }
        }
    }
}

