/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.BodyAdapter;
import com.github.mizosoft.methanol.BodyDecoder;
import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MoreBodySubscribers;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.extensions.ImmutableResponseInfo;
import java.io.Reader;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MoreBodyHandlers {
    private MoreBodyHandlers() {
    }

    public static <T, S extends Flow.Subscriber<? super List<ByteBuffer>>> HttpResponse.BodyHandler<T> fromAsyncSubscriber(S downstream, Function<? super S, ? extends CompletionStage<T>> asyncFinisher) {
        Objects.requireNonNull(downstream, "downstream");
        Objects.requireNonNull(asyncFinisher, "asyncFinisher");
        return info -> MoreBodySubscribers.fromAsyncSubscriber(downstream, asyncFinisher);
    }

    public static <T> HttpResponse.BodyHandler<T> withReadTimeout(HttpResponse.BodyHandler<T> baseHandler, Duration timeout2) {
        Objects.requireNonNull(baseHandler, "baseHandler");
        Objects.requireNonNull(timeout2, "timeout");
        return info -> MoreBodySubscribers.withReadTimeout(baseHandler.apply(info), timeout2);
    }

    public static <T> HttpResponse.BodyHandler<T> withReadTimeout(HttpResponse.BodyHandler<T> baseHandler, Duration timeout2, ScheduledExecutorService scheduler) {
        Objects.requireNonNull(baseHandler, "baseHandler");
        Objects.requireNonNull(timeout2, "timeout");
        Objects.requireNonNull(timeout2, "scheduler");
        return info -> MoreBodySubscribers.withReadTimeout(baseHandler.apply(info), timeout2, scheduler);
    }

    public static HttpResponse.BodyHandler<ReadableByteChannel> ofByteChannel() {
        return info -> MoreBodySubscribers.ofByteChannel();
    }

    public static HttpResponse.BodyHandler<Reader> ofReader() {
        return info -> MoreBodySubscribers.ofReader(MoreBodyHandlers.getCharsetOrUtf8(info.headers()));
    }

    public static HttpResponse.BodyHandler<Reader> ofReader(Charset charset) {
        Objects.requireNonNull(charset);
        return info -> MoreBodySubscribers.ofReader(charset);
    }

    public static <T> HttpResponse.BodyHandler<T> ofObject(Class<T> type) {
        return MoreBodyHandlers.ofObject(TypeRef.from(type));
    }

    public static <T> HttpResponse.BodyHandler<T> ofObject(TypeRef<T> type) {
        MoreBodyHandlers.requireSupport(type);
        return info -> MoreBodySubscribers.ofObject(type, MoreBodyHandlers.mediaTypeOrNull(info.headers()));
    }

    public static <T> HttpResponse.BodyHandler<Supplier<T>> ofDeferredObject(Class<T> type) {
        return MoreBodyHandlers.ofDeferredObject(TypeRef.from(type));
    }

    public static <T> HttpResponse.BodyHandler<Supplier<T>> ofDeferredObject(TypeRef<T> type) {
        MoreBodyHandlers.requireSupport(type);
        return info -> MoreBodySubscribers.ofDeferredObject(type, MoreBodyHandlers.mediaTypeOrNull(info.headers()));
    }

    public static <T> HttpResponse.BodyHandler<T> decoding(HttpResponse.BodyHandler<T> downstreamHandler) {
        Objects.requireNonNull(downstreamHandler);
        return new DecodingHandler<T>(downstreamHandler, null);
    }

    public static <T> HttpResponse.BodyHandler<T> decoding(HttpResponse.BodyHandler<T> downstreamHandler, Executor executor) {
        Objects.requireNonNull(downstreamHandler, "downstreamHandler");
        Objects.requireNonNull(executor, "executor");
        return new DecodingHandler<T>(downstreamHandler, executor);
    }

    private static Charset getCharsetOrUtf8(HttpHeaders headers) {
        return headers.firstValue("Content-Type").map(s2 -> MediaType.parse(s2).charsetOrDefault(StandardCharsets.UTF_8)).orElse(StandardCharsets.UTF_8);
    }

    private static void requireSupport(TypeRef<?> type) {
        if (BodyAdapter.Decoder.installed().stream().noneMatch(d -> d.supportsType(type))) {
            throw new UnsupportedOperationException("unsupported conversion to an object of type <" + type + ">");
        }
    }

    private static @Nullable MediaType mediaTypeOrNull(HttpHeaders headers) {
        return headers.firstValue("Content-Type").map(MediaType::parse).orElse(null);
    }

    private static final class DecodingHandler<T>
    implements HttpResponse.BodyHandler<T> {
        private final HttpResponse.BodyHandler<T> downstreamHandler;
        private final @Nullable Executor executor;

        DecodingHandler(HttpResponse.BodyHandler<T> downstreamHandler, @Nullable Executor executor) {
            this.downstreamHandler = downstreamHandler;
            this.executor = executor;
        }

        @Override
        public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo info) {
            Optional<String> encHeader = info.headers().firstValue("Content-Encoding");
            if (encHeader.isEmpty()) {
                return this.downstreamHandler.apply(info);
            }
            String enc = encHeader.get();
            BodyDecoder.Factory factory = BodyDecoder.Factory.getFactory(enc).orElseThrow(() -> new UnsupportedOperationException("unsupported encoding: " + enc));
            HttpHeaders headersCopy = HttpHeaders.of(info.headers().map(), (n, v) -> !"Content-Encoding".equalsIgnoreCase((String)n) && !"Content-Length".equalsIgnoreCase((String)n));
            HttpResponse.BodySubscriber<T> downstream = this.downstreamHandler.apply(new ImmutableResponseInfo(info.statusCode(), headersCopy, info.version()));
            return this.executor != null ? factory.create(downstream, this.executor) : factory.create(downstream);
        }
    }
}

