/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.internal.Validate;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TypeRef<T> {
    private final Type type;
    private @MonotonicNonNull Class<?> rawType;

    protected TypeRef() {
        Type superClass = this.getClass().getGenericSuperclass();
        Validate.requireState(superClass instanceof ParameterizedType, "not used in parameterized form");
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    private TypeRef(Type type) {
        this.type = type;
        this.rawType = TypeRef.findRawType(type);
    }

    public final Type type() {
        return this.type;
    }

    public final Class<? super T> rawType() {
        Class<?> clz = this.rawType;
        if (clz == null) {
            try {
                clz = TypeRef.findRawType(this.type);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError("couldn't get raw type of: " + this.type, e);
            }
            this.rawType = clz;
        }
        return clz;
    }

    public final Class<T> exactRawType() {
        if (!(this.type instanceof Class)) {
            throw new UnsupportedOperationException("<" + this.type + "> is not a raw type");
        }
        return (Class)this.type;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeRef)) {
            return false;
        }
        return this.type.equals(((TypeRef)obj).type);
    }

    public int hashCode() {
        return 31 * this.type.hashCode();
    }

    public String toString() {
        return this.type.getTypeName();
    }

    private static Class<?> findRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            Validate.requireArgument(rawType instanceof Class, "ParameterizedType::getRawType of %s returned a non-raw type: %s", type, rawType);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = TypeRef.findRawType(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return TypeRef.rawUpperBound(((TypeVariable)type).getBounds());
        }
        if (type instanceof WildcardType) {
            return TypeRef.rawUpperBound(((WildcardType)type).getUpperBounds());
        }
        throw new IllegalArgumentException("unsupported specialization of java.lang.reflect.Type: " + type);
    }

    private static Class<?> rawUpperBound(Type[] upperBounds) {
        return upperBounds.length > 0 ? TypeRef.findRawType(upperBounds[0]) : Object.class;
    }

    public static TypeRef<?> from(Type type) {
        return new ExplicitTypeRef(type);
    }

    public static <U> TypeRef<U> from(Class<U> rawType) {
        return new ExplicitTypeRef(rawType);
    }

    private static final class ExplicitTypeRef<T>
    extends TypeRef<T> {
        ExplicitTypeRef(Type type) {
            super(Objects.requireNonNull(type));
        }
    }
}

