/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.decoder;

import com.github.mizosoft.methanol.internal.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;

public interface AsyncDecoder
extends AutoCloseable {
    public String encoding();

    public void decode(ByteSource var1, ByteSink var2) throws IOException;

    @Override
    public void close();

    public static interface ByteSink {
        public ByteBuffer currentSink();

        default public void pushBytes(ByteBuffer src) {
            while (src.hasRemaining()) {
                Utils.copyRemaining(src, this.currentSink());
            }
        }
    }

    public static interface ByteSource {
        public ByteBuffer currentSource();

        default public void pullBytes(ByteBuffer dst) {
            for (int toCopy = (int)Math.min(this.remaining(), (long)dst.remaining()); toCopy > 0; toCopy -= Utils.copyRemaining(this.currentSource(), dst)) {
            }
        }

        public long remaining();

        default public boolean hasRemaining() {
            return this.remaining() > 0L;
        }

        public boolean finalSource();
    }
}

