/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.CacheAwareResponse;
import com.github.mizosoft.methanol.CacheControl;
import com.github.mizosoft.methanol.HttpCache;
import com.github.mizosoft.methanol.HttpStatus;
import com.github.mizosoft.methanol.Methanol;
import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.cache.CacheResponse;
import com.github.mizosoft.methanol.internal.cache.CacheResponseMetadata;
import com.github.mizosoft.methanol.internal.cache.DateUtils;
import com.github.mizosoft.methanol.internal.cache.InternalCache;
import com.github.mizosoft.methanol.internal.cache.NetworkResponse;
import com.github.mizosoft.methanol.internal.cache.RawResponse;
import com.github.mizosoft.methanol.internal.extensions.Handlers;
import com.github.mizosoft.methanol.internal.extensions.HeadersBuilder;
import com.github.mizosoft.methanol.internal.extensions.ResponseBuilder;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.function.Unchecked;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CacheInterceptor
implements Methanol.Interceptor {
    private static final System.Logger logger = System.getLogger(CacheInterceptor.class.getName());
    private final InternalCache cache;
    private final HttpCache.Listener listener;
    private final Executor cacheExecutor;
    private final Executor handlerExecutor;
    private final Clock clock;

    public CacheInterceptor(InternalCache cache, HttpCache.Listener listener, Executor cacheExecutor, Executor handlerExecutor, Clock clock) {
        this.cache = cache;
        this.listener = listener;
        this.cacheExecutor = cacheExecutor;
        this.handlerExecutor = handlerExecutor;
        this.clock = clock;
    }

    @Override
    public <T> HttpResponse<T> intercept(HttpRequest request, Methanol.Interceptor.Chain<T> chain) throws IOException, InterruptedException {
        return Utils.block(this.exchange(request, chain, false)).handle(chain.bodyHandler());
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> interceptAsync(HttpRequest request, Methanol.Interceptor.Chain<T> chain) {
        return ((CompletableFuture)this.exchange(request, chain, true).thenCompose(rawResponse -> rawResponse.handleAsync(chain.bodyHandler(), this.handlerExecutor))).thenApply(Function.identity());
    }

    public CompletableFuture<RawResponse> exchange(HttpRequest request, Methanol.Interceptor.Chain<?> chain, boolean async) {
        this.listener.onRequest(request);
        Instant requestTime = this.clock.instant();
        AsyncAdapter asyncAdapter = new AsyncAdapter(async);
        Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> publisherChain = Handlers.toPublisherChain(chain, this.handlerExecutor);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getCacheResponse(request, chain, asyncAdapter).thenApply(cacheResponse -> new Exchange(request, publisherChain, (CacheResponse)cacheResponse, requestTime, asyncAdapter))).thenCompose(Exchange::evaluate)).thenApply(Exchange::serveResponse)).thenApply(response -> {
            this.listener.onResponse(request, (CacheAwareResponse)response.get());
            return response;
        });
    }

    private CompletableFuture<@Nullable CacheResponse> getCacheResponse(HttpRequest request, Methanol.Interceptor.Chain<?> chain, AsyncAdapter asyncAdapter) {
        if (!"GET".equalsIgnoreCase(request.method()) || CacheInterceptor.hasPreconditions(request.headers()) || chain.pushPromiseHandler().isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        return asyncAdapter.get(this.cache, request, this.cacheExecutor);
    }

    private void handleAsyncRevalidation(@Nullable Exchange networkExchange, @Nullable Throwable error) {
        NetworkResponse networkResponse;
        NetworkResponse networkResponse2 = networkResponse = networkExchange != null ? networkExchange.networkResponse : null;
        assert (networkResponse != null || error != null);
        if (networkResponse != null) {
            networkResponse.discard(this.handlerExecutor);
        } else {
            logger.log(System.Logger.Level.WARNING, "asynchronous revalidation failure", error);
        }
    }

    private static boolean hasPreconditions(HttpHeaders headers) {
        return headers.map().keySet().stream().anyMatch(CacheInterceptor::isPreconditionField);
    }

    private static boolean isPreconditionField(String name) {
        return "If-Match".equalsIgnoreCase(name) || "If-Unmodified-Since".equalsIgnoreCase(name) || "If-None-Match".equalsIgnoreCase(name) || "If-Modified-Since".equalsIgnoreCase(name) || "If-Range".equalsIgnoreCase(name);
    }

    private static boolean isImplicitField(String name) {
        return "Cookie".equalsIgnoreCase(name) || "Cookie2".equalsIgnoreCase(name) || "Authorization".equalsIgnoreCase(name) || "Proxy-Authorization".equalsIgnoreCase(name);
    }

    private static boolean isNetworkOrServerError(@Nullable NetworkResponse networkResponse, @Nullable Throwable error) {
        assert (networkResponse != null || error != null);
        if (networkResponse != null) {
            return HttpStatus.isServerError(networkResponse.get());
        }
        Throwable cause = Utils.getDeepCompletionCause(error);
        if (cause instanceof UncheckedIOException) {
            cause = cause.getCause();
        }
        return cause instanceof ConnectException || cause instanceof UnknownHostException;
    }

    private static boolean isCacheable(HttpRequest request, TrackedResponse<?> response) {
        if (!"GET".equalsIgnoreCase(request.method())) {
            return false;
        }
        if (response.statusCode() == 206) {
            return false;
        }
        if (!request.uri().equals(response.uri()) || !request.method().equalsIgnoreCase(response.request().method())) {
            return false;
        }
        CacheControl responseCacheControl = CacheControl.parse(response.headers());
        if (responseCacheControl.noStore() || CacheControl.parse(request.headers()).noStore()) {
            return false;
        }
        Set<String> varyFields = CacheResponseMetadata.varyFields(response.headers());
        if (varyFields.contains("*") || varyFields.stream().anyMatch(CacheInterceptor::isImplicitField)) {
            return false;
        }
        return responseCacheControl.maxAge().isPresent() || responseCacheControl.isPublic() || responseCacheControl.isPrivate() || CacheInterceptor.isCacheableByDefault(response.statusCode()) || response.headers().firstValue("Expires").filter(DateUtils::isHttpDate).isPresent();
    }

    private static boolean isCacheableByDefault(int statusCode) {
        switch (statusCode) {
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                return true;
            }
        }
        return false;
    }

    private static CacheResponse updateCacheResponse(CacheResponse cacheResponse, NetworkResponse networkResponse) {
        return cacheResponse.with(builder -> builder.clearHeaders().headers(CacheInterceptor.mergeHeaders(cacheResponse.get().headers(), networkResponse.get().headers())).timeRequestSent(networkResponse.get().timeRequestSent()).timeResponseReceived(networkResponse.get().timeResponseReceived()));
    }

    private static HttpHeaders mergeHeaders(HttpHeaders storedHeaders, HttpHeaders networkHeaders) {
        HeadersBuilder builder = new HeadersBuilder();
        builder.addAll(storedHeaders);
        builder.removeIf((name, value2) -> "Warning".equalsIgnoreCase((String)name) && value2.startsWith("1"));
        builder.setAll(networkHeaders);
        storedHeaders.firstValue("Content-Length").ifPresent(value2 -> builder.set("Content-Length", (String)value2));
        return builder.build();
    }

    private static List<URI> invalidatedUris(HttpRequest request, TrackedResponse<?> response) {
        if (CacheInterceptor.isUnsafe(request.method()) && (HttpStatus.isSuccessful(response) || HttpStatus.isRedirection(response))) {
            ArrayList<URI> invalidatedUris = new ArrayList<URI>();
            invalidatedUris.add(request.uri());
            CacheInterceptor.invalidatedLocationUri(request.uri(), response.headers(), "Location").ifPresent(invalidatedUris::add);
            CacheInterceptor.invalidatedLocationUri(request.uri(), response.headers(), "Content-Location").ifPresent(invalidatedUris::add);
            return Collections.unmodifiableList(invalidatedUris);
        }
        return List.of();
    }

    private static Optional<URI> invalidatedLocationUri(URI requestUri, HttpHeaders responseHeaders, String locationField) {
        return responseHeaders.firstValue(locationField).map(requestUri::resolve).filter(resolvedUri -> Objects.equals(requestUri.getHost(), resolvedUri.getHost()));
    }

    private static boolean isUnsafe(String method) {
        return !"GET".equalsIgnoreCase(method) && !"HEAD".equalsIgnoreCase(method) && !"OPTIONS".equalsIgnoreCase(method) && !"TRACE".equalsIgnoreCase(method);
    }

    private static final class AsyncAdapter {
        private final boolean async;

        AsyncAdapter(boolean async) {
            this.async = async;
        }

        <T> CompletableFuture<HttpResponse<T>> forward(Methanol.Interceptor.Chain<T> chain, HttpRequest request) {
            return this.async ? chain.forwardAsync(request) : Unchecked.supplyAsync(() -> chain.forward(request), FlowSupport.SYNC_EXECUTOR);
        }

        CompletableFuture<@Nullable CacheResponse> get(InternalCache cache, HttpRequest request, Executor cacheExecutor) {
            Executor executor = this.async ? cacheExecutor : FlowSupport.SYNC_EXECUTOR;
            return Unchecked.supplyAsync(() -> cache.get(request), executor);
        }
    }

    private final class Exchange {
        private final HttpRequest request;
        private final Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain;
        private final @Nullable CacheResponse cacheResponse;
        private final @Nullable NetworkResponse networkResponse;
        private final Instant requestTime;
        private final CacheControl requestCacheControl;
        private final AsyncAdapter asyncAdapter;

        Exchange(HttpRequest request,  @Nullable Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain, CacheResponse cacheResponse, Instant requestTime, AsyncAdapter asyncAdapter) {
            this(request, chain, cacheResponse, null, requestTime, CacheControl.parse(request.headers()), asyncAdapter);
        }

        private Exchange(HttpRequest request,  @Nullable Methanol.Interceptor.Chain<Flow.Publisher<List<ByteBuffer>>> chain, @Nullable CacheResponse cacheResponse, NetworkResponse networkResponse, Instant requestTime, CacheControl requestCacheControl, AsyncAdapter asyncAdapter) {
            this.request = request;
            this.chain = chain;
            this.cacheResponse = cacheResponse;
            this.networkResponse = networkResponse;
            this.requestTime = requestTime;
            this.requestCacheControl = requestCacheControl;
            this.asyncAdapter = asyncAdapter;
        }

        CompletableFuture<Exchange> evaluate() {
            if (this.cacheResponse != null && this.cacheResponse.isServable()) {
                return CompletableFuture.completedFuture(this);
            }
            if (this.cacheResponse != null && this.cacheResponse.isServableWhileRevalidating()) {
                ((CompletableFuture)this.networkExchange().thenApply(Exchange::updateCache)).whenComplete((x$0, x$1) -> CacheInterceptor.this.handleAsyncRevalidation((Exchange)x$0, (Throwable)x$1));
                return CompletableFuture.completedFuture(this);
            }
            if (this.requestCacheControl.onlyIfCached()) {
                return CompletableFuture.completedFuture(this);
            }
            CacheInterceptor.this.listener.onNetworkUse(this.request, this.cacheResponse != null ? this.cacheResponse.get() : null);
            return ((CompletableFuture)this.networkExchange().handle(this::handleNetworkOrServerError)).thenApply(Exchange::updateCache);
        }

        Exchange updateCache() {
            if (this.networkResponse == null) {
                return this;
            }
            if (this.cacheResponse != null && this.networkResponse.get().statusCode() == 304) {
                this.networkResponse.discard(CacheInterceptor.this.handlerExecutor);
                CacheResponse updatedCacheResponse = CacheInterceptor.updateCacheResponse(this.cacheResponse, this.networkResponse);
                CacheInterceptor.this.cacheExecutor.execute(() -> CacheInterceptor.this.cache.update(updatedCacheResponse));
                return this.withCacheResponse(updatedCacheResponse);
            }
            if (CacheInterceptor.isCacheable(this.request, this.networkResponse.get())) {
                NetworkResponse cacheUpdatingNetworkResponse = CacheInterceptor.this.cache.put(this.request, this.cacheResponse, this.networkResponse);
                if (cacheUpdatingNetworkResponse != null) {
                    return this.withNetworkResponse(cacheUpdatingNetworkResponse);
                }
            } else {
                CacheInterceptor.invalidatedUris(this.request, this.networkResponse.get()).forEach(CacheInterceptor.this.cache::remove);
            }
            return this;
        }

        RawResponse serveResponse() {
            if (this.networkResponse == null) {
                if (this.cacheResponse != null && (this.cacheResponse.isServable() || this.cacheResponse.isServableWhileRevalidating() || this.cacheResponse.isServableOnError())) {
                    CacheResponse cacheResponse = this.cacheResponse.withCacheHeaders();
                    return cacheResponse.with(builder -> builder.request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.HIT).cacheResponse(cacheResponse.get()).timeRequestSent(this.requestTime).timeResponseReceived(CacheInterceptor.this.clock.instant()));
                }
                if (this.cacheResponse != null) {
                    this.cacheResponse.close();
                }
                return NetworkResponse.from(new ResponseBuilder().uri(this.request.uri()).request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.UNSATISFIABLE).statusCode(504).version(HttpClient.Version.HTTP_1_1).timeRequestSent(this.requestTime).timeResponseReceived(CacheInterceptor.this.clock.instant()).body(FlowSupport.emptyPublisher()).buildTracked());
            }
            if (this.cacheResponse != null && this.networkResponse.get().statusCode() == 304) {
                return this.cacheResponse.with(builder -> builder.request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.CONDITIONAL_HIT).cacheResponse(this.cacheResponse.get()).networkResponse(this.networkResponse.get()));
            }
            if (this.cacheResponse != null) {
                this.cacheResponse.close();
            }
            return this.networkResponse.with(builder -> builder.request(this.request).cacheStatus(CacheAwareResponse.CacheStatus.MISS).cacheResponse(this.cacheResponse != null ? this.cacheResponse.get() : null).networkResponse(this.networkResponse.get()));
        }

        private CompletableFuture<Exchange> networkExchange() {
            HttpRequest networkRequest = this.cacheResponse != null ? this.cacheResponse.toValidationRequest(this.request) : this.request;
            return ((CompletableFuture)this.asyncAdapter.forward(this.chain, networkRequest).thenApply(response -> NetworkResponse.from(ResponseBuilder.newBuilder(response).timeRequestSent(this.requestTime).timeResponseReceived(CacheInterceptor.this.clock.instant()).buildTracked()))).thenApply(this::withNetworkResponse);
        }

        private Exchange handleNetworkOrServerError(@Nullable Exchange networkExchange, @Nullable Throwable error) {
            NetworkResponse networkResponse;
            NetworkResponse networkResponse2 = networkResponse = networkExchange != null ? networkExchange.networkResponse : null;
            assert (networkResponse != null || error != null);
            if (CacheInterceptor.isNetworkOrServerError(networkResponse, error) && this.cacheResponse != null && this.cacheResponse.isServableOnError()) {
                if (networkResponse != null) {
                    networkResponse.discard(CacheInterceptor.this.handlerExecutor);
                }
                return this;
            }
            if (error != null) {
                if (this.cacheResponse != null) {
                    this.cacheResponse.close();
                }
                throw new CompletionException(error);
            }
            return networkExchange;
        }

        private Exchange withCacheResponse(@Nullable CacheResponse cacheResponse) {
            return new Exchange(this.request, this.chain, cacheResponse, this.networkResponse, this.requestTime, this.requestCacheControl, this.asyncAdapter);
        }

        private Exchange withNetworkResponse(@Nullable NetworkResponse networkResponse) {
            return new Exchange(this.request, this.chain, this.cacheResponse, networkResponse, this.requestTime, this.requestCacheControl, this.asyncAdapter);
        }
    }
}

