/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.internal.Validate;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DateUtils {
    private static final System.Logger logger = System.getLogger(DateUtils.class.getName());
    private static final DateTimeFormatter PREFERRED_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME;
    private static final List<DateTimeFormatter> FORMATTERS = List.of(PREFERRED_FORMATTER, DateTimeFormatter.ofPattern("EEEE, dd-MMM-yy HH:mm:ss 'GMT'"), DateTimeFormatter.ofPattern("EEEE MMM pdd HH:mm:ss yyyy"));

    public static String formatHttpDate(LocalDateTime dateTime) {
        return PREFERRED_FORMATTER.format(dateTime.atOffset(ZoneOffset.UTC));
    }

    public static boolean isHttpDate(String value2) {
        return DateUtils.toHttpDate0(value2, false) != null;
    }

    static @Nullable LocalDateTime toHttpDate(String value2) {
        return DateUtils.toHttpDate0(value2, true);
    }

    static @Nullable LocalDateTime toHttpDate0(String value2, boolean logFailure) {
        DateTimeException parseException = null;
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                TemporalAccessor parsed = formatter.parse(value2);
                LocalDateTime dateTime = LocalDateTime.from(parsed);
                ZoneId zone = parsed.query(TemporalQueries.zone());
                if (zone == null || zone instanceof ZoneOffset) {
                    ZoneOffset offset = (ZoneOffset)zone;
                    return offset == null || offset.equals(ZoneOffset.UTC) ? dateTime : DateUtils.toUtcDateTime(dateTime.toInstant(offset));
                }
                if (!logFailure) continue;
                throw new DateTimeException("unsupported zone: " + zone);
            }
            catch (DateTimeException e) {
                if (!logFailure) continue;
                if (parseException != null) {
                    parseException.addSuppressed(e);
                    continue;
                }
                parseException = e;
            }
        }
        if (logFailure) {
            logger.log(System.Logger.Level.WARNING, () -> "couldn't parse HTTP date: " + value2, parseException);
        }
        return null;
    }

    public static Duration toDeltaSeconds(String value2) {
        long secondsLong = Long.parseLong(value2);
        Validate.requireArgument(secondsLong >= 0L, "delta seconds can't be negative");
        int secondsInt = (int)Math.min(secondsLong, Integer.MAX_VALUE);
        return Duration.ofSeconds(secondsInt);
    }

    static @Nullable Duration toDeltaSecondsOrNull(String value2) {
        try {
            return DateUtils.toDeltaSeconds(value2);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    static LocalDateTime toUtcDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    static Duration max(Duration left, Duration right) {
        return left.compareTo(right) >= 0 ? left : right;
    }
}

