/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;

public class StoreIO {
    private StoreIO() {
    }

    static ByteBuffer readNBytes(FileChannel channel, int byteCount) throws IOException {
        return StoreIO.readNBytes(channel, byteCount, -1L);
    }

    static ByteBuffer readNBytes(FileChannel channel, int byteCount, long position) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(byteCount);
        int totalRead = 0;
        int read = 0;
        while (read >= 0 && buffer.hasRemaining()) {
            int n = read = position >= 0L ? channel.read(buffer, position) : channel.read(buffer);
            if (read >= 0) {
                totalRead += read;
                if (position >= 0L) {
                    position += (long)read;
                }
            }
            totalRead += read;
        }
        if (buffer.hasRemaining()) {
            throw new EOFException(String.format("expected %d bytes, found %d", byteCount, totalRead));
        }
        return buffer.flip();
    }

    static CompletableFuture<Integer> readBytesAsync(AsynchronousFileChannel channel, ByteBuffer dst, long position) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        channel.read(dst, position, dst, new ReadCompletionHandler(channel, future, position));
        return future;
    }

    static void writeBytes(FileChannel channel, ByteBuffer src) throws IOException {
        do {
            channel.write(src);
        } while (src.hasRemaining());
    }

    static void writeBytes(FileChannel channel, ByteBuffer src, long position) throws IOException {
        do {
            int written = channel.write(src, position);
            position += (long)written;
        } while (src.hasRemaining());
    }

    static CompletableFuture<Integer> writeBytesAsync(AsynchronousFileChannel channel, ByteBuffer src, long position) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        channel.write(src, position, src, new WriteCompletionHandler(channel, future, position));
        return future;
    }

    private static final class ReadCompletionHandler
    implements CompletionHandler<Integer, ByteBuffer> {
        private final AsynchronousFileChannel channel;
        private final CompletableFuture<Integer> future;
        private final long position;
        private final int totalRead;

        ReadCompletionHandler(AsynchronousFileChannel channel, CompletableFuture<Integer> future, long position) {
            this(channel, future, position, 0);
        }

        private ReadCompletionHandler(AsynchronousFileChannel channel, CompletableFuture<Integer> future, long position, int totalRead) {
            this.channel = channel;
            this.future = future;
            this.position = position;
            this.totalRead = totalRead;
        }

        @Override
        public void completed(Integer read, ByteBuffer dst) {
            if (read >= 0 && dst.hasRemaining()) {
                long nextPosition = this.position + (long)read.intValue();
                this.channel.read(dst, nextPosition, dst, new ReadCompletionHandler(this.channel, this.future, nextPosition, this.totalRead + read));
            } else if (this.totalRead > 0) {
                this.future.complete(this.totalRead + Math.max(0, read));
            } else {
                this.future.complete(read);
            }
        }

        @Override
        public void failed(Throwable exc, ByteBuffer dst) {
            this.future.completeExceptionally(exc);
        }
    }

    private static final class WriteCompletionHandler
    implements CompletionHandler<Integer, ByteBuffer> {
        private final AsynchronousFileChannel channel;
        private final CompletableFuture<Integer> future;
        private final long position;
        private final int totalWritten;

        WriteCompletionHandler(AsynchronousFileChannel channel, CompletableFuture<Integer> future, long position) {
            this(channel, future, position, 0);
        }

        private WriteCompletionHandler(AsynchronousFileChannel channel, CompletableFuture<Integer> future, long position, int totalWritten) {
            this.channel = channel;
            this.future = future;
            this.position = position;
            this.totalWritten = totalWritten;
        }

        @Override
        public void completed(Integer written, ByteBuffer src) {
            if (src.hasRemaining()) {
                long nextPosition = this.position + (long)written.intValue();
                this.channel.write(src, nextPosition, src, new WriteCompletionHandler(this.channel, this.future, nextPosition, this.totalWritten + written));
            } else {
                this.future.complete(this.totalWritten + written);
            }
        }

        @Override
        public void failed(Throwable exc, ByteBuffer src) {
            this.future.completeExceptionally(exc);
        }
    }
}

