/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractSubscription<T>
implements Flow.Subscription {
    private static final System.Logger logger = System.getLogger(AbstractSubscription.class.getName());
    private static final int RUNNING = 1;
    private static final int KEEP_ALIVE = 2;
    private static final int SUBSCRIBED = 4;
    private static final int ERROR = 8;
    private static final int CANCELLED = 16;
    private static final VarHandle STATE;
    private static final VarHandle PENDING_ERROR;
    private static final VarHandle DEMAND;
    private final Flow.Subscriber<? super T> downstream;
    private final Executor executor;
    private volatile int state;
    private volatile long demand;
    private volatile @Nullable Throwable pendingError;

    protected AbstractSubscription(Flow.Subscriber<? super T> downstream, Executor executor) {
        this.downstream = downstream;
        this.executor = executor;
    }

    @Override
    public final void request(long n) {
        if (n > 0L && FlowSupport.getAndAddDemand(this, DEMAND, n) == 0L) {
            this.signal();
        } else if (n <= 0L) {
            this.signalError(FlowSupport.illegalRequest());
        }
    }

    @Override
    public final void cancel() {
        if ((this.getAndBitwiseOrState(16) & 0x10) == 0) {
            this.guardedAbort(true);
        }
    }

    public final void signal(boolean force) {
        if (force || this.demand > 0L) {
            this.signal();
        }
    }

    public final void signalError(Throwable error) {
        this.recordError(error);
        this.signal();
    }

    protected abstract long emit(Flow.Subscriber<? super T> var1, long var2);

    protected void abort(boolean flowInterrupted) {
    }

    private void guardedAbort(boolean flowInterrupted) {
        try {
            this.abort(flowInterrupted);
        }
        catch (Throwable t) {
            logger.log(System.Logger.Level.WARNING, "exception thrown during subscription cancellation", t);
        }
    }

    protected final boolean isCancelled() {
        return (this.state & 0x10) != 0;
    }

    protected final boolean hasPendingErrors() {
        return this.pendingError != null;
    }

    protected final void cancelOnError(Flow.Subscriber<? super T> downstream, Throwable error, boolean flowInterrupted) {
        if ((this.getAndBitwiseOrState(16) & 0x10) == 0) {
            this.guardedAbort(flowInterrupted);
            try {
                downstream.onError(error);
            }
            catch (Throwable t) {
                logger.log(System.Logger.Level.WARNING, () -> "exception thrown by subscriber's onError: " + downstream, t);
            }
        }
    }

    protected final void cancelOnComplete(Flow.Subscriber<? super T> downstream) {
        if ((this.getAndBitwiseOrState(16) & 0x10) == 0) {
            this.guardedAbort(false);
            try {
                downstream.onComplete();
            }
            catch (Throwable t) {
                logger.log(System.Logger.Level.WARNING, () -> "exception thrown by subscriber's onComplete: " + downstream, t);
            }
        }
    }

    protected final boolean submitOnNext(Flow.Subscriber<? super T> downstream, T item) {
        if (!this.isCancelled() && !this.hasPendingErrors()) {
            try {
                downstream.onNext(item);
                return true;
            }
            catch (Throwable t) {
                this.cancelOnError(downstream, this.recordError(t), true);
            }
        }
        return false;
    }

    private void signal() {
        int s2;
        while (((s2 = this.state) & 0x10) == 0) {
            int setBit = (s2 & 1) != 0 ? 2 : 1;
            if (!STATE.compareAndSet(this, s2, s2 | setBit)) continue;
            if (setBit != 1) break;
            try {
                this.executor.execute(this::run);
                break;
            }
            catch (Error | RuntimeException e) {
                logger.log(System.Logger.Level.ERROR, "couldn't execute subscription's signaller task", e);
                this.cancel();
                throw e;
            }
        }
    }

    private void run() {
        int s2;
        Flow.Subscriber<? super T> d = this.downstream;
        this.subscribeOnDrain(d);
        long x = 0L;
        long r = this.demand;
        while (((s2 = this.state) & 0x10) == 0) {
            int unsetBit;
            boolean exhausted;
            if ((s2 & 8) != 0) {
                this.cancelOnError(d, Validate.castNonNull(this.pendingError), false);
                continue;
            }
            long emitted = this.emit(d, r - x);
            if (emitted > 0L) {
                r = this.demand;
                if ((x += emitted) != r) continue;
                r = FlowSupport.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                continue;
            }
            if (r != (r = this.demand)) continue;
            boolean bl = exhausted = x <= 0L;
            if (!exhausted) {
                r = FlowSupport.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                boolean bl2 = exhausted = r <= 0L;
            }
            if (!exhausted || !STATE.compareAndSet(this, s2, s2 & ~(unsetBit = (s2 & 2) != 0 ? 2 : 1)) || unsetBit != 1) continue;
            break;
        }
    }

    private void subscribeOnDrain(Flow.Subscriber<? super T> downstream) {
        if ((this.state & 0x14) == 0 && (this.getAndBitwiseOrState(4) & 0x14) == 0) {
            try {
                downstream.onSubscribe(this);
            }
            catch (Throwable t) {
                this.cancelOnError(downstream, this.recordError(t), true);
            }
        }
    }

    @CanIgnoreReturnValue
    private Throwable recordError(Throwable error) {
        do {
            Throwable currentPendingError;
            if ((currentPendingError = this.pendingError) == null) continue;
            currentPendingError.addSuppressed(error);
            return currentPendingError;
        } while (!PENDING_ERROR.compareAndSet(this, null, error));
        this.getAndBitwiseOrState(8);
        return error;
    }

    private int getAndBitwiseOrState(int bits) {
        return STATE.getAndBitwiseOr(this, bits);
    }

    protected long currentDemand() {
        return this.demand;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            STATE = lookup.findVarHandle(AbstractSubscription.class, "state", Integer.TYPE);
            DEMAND = lookup.findVarHandle(AbstractSubscription.class, "demand", Long.TYPE);
            PENDING_ERROR = lookup.findVarHandle(AbstractSubscription.class, "pendingError", Throwable.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

