/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.flow.Upstream;

public final class Prefetcher {
    private final int prefetch = FlowSupport.prefetch();
    private final int prefetchThreshold = FlowSupport.prefetchThreshold();
    private volatile int upstreamWindow;

    public void initialize(Upstream upstream) {
        this.upstreamWindow = this.prefetch;
        upstream.request(this.prefetch);
    }

    public void update(Upstream upstream) {
        int update = this.upstreamWindow - 1;
        if (update <= this.prefetchThreshold) {
            this.upstreamWindow = this.prefetch;
            upstream.request(this.prefetch - update);
        } else {
            this.upstreamWindow = update;
        }
    }

    int currentWindow() {
        return this.upstreamWindow;
    }
}

