/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.spi;

import com.github.mizosoft.methanol.BodyDecoder;
import com.github.mizosoft.methanol.internal.annotations.DefaultProvider;
import com.github.mizosoft.methanol.internal.spi.ServiceCache;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DecoderFactoryFinder {
    private static final ServiceCache<BodyDecoder.Factory> CACHE = new ServiceCache<BodyDecoder.Factory>(BodyDecoder.Factory.class);
    private static volatile @MonotonicNonNull Map<String, BodyDecoder.Factory> bindings;

    private DecoderFactoryFinder() {
    }

    public static List<BodyDecoder.Factory> findInstalledFactories() {
        return CACHE.getProviders();
    }

    public static Map<String, BodyDecoder.Factory> getInstalledBindings() {
        Map<String, BodyDecoder.Factory> cached = bindings;
        if (cached == null) {
            bindings = cached = DecoderFactoryFinder.createBindings();
        }
        return cached;
    }

    private static Map<String, BodyDecoder.Factory> createBindings() {
        TreeMap<String, BodyDecoder.Factory> bindings = new TreeMap<String, BodyDecoder.Factory>(String.CASE_INSENSITIVE_ORDER);
        for (BodyDecoder.Factory f : DecoderFactoryFinder.findInstalledFactories()) {
            String enc = f.encoding();
            bindings.merge(enc, f, (f1, f2) -> f1.getClass().isAnnotationPresent(DefaultProvider.class) ? f2 : f1);
        }
        return Collections.unmodifiableMap(bindings);
    }
}

