/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.text;

import com.github.mizosoft.methanol.internal.Validate;

public interface CharMatcher {
    public boolean matches(char var1);

    default public boolean allMatch(String s2) {
        return s2.chars().allMatch((int i) -> this.matches((char)i));
    }

    default public CharMatcher or(CharMatcher other) {
        return c -> this.matches(c) || other.matches(c);
    }

    public static CharMatcher alpha() {
        return c -> {
            char lower = Character.toLowerCase(c);
            return lower >= 'a' && lower <= 'z';
        };
    }

    public static CharMatcher num() {
        return c -> c >= '0' && c <= '9';
    }

    public static CharMatcher alphaNum() {
        return CharMatcher.alpha().or(CharMatcher.num());
    }

    public static CharMatcher chars(String chars) {
        return c -> chars.indexOf(c) >= 0;
    }

    public static CharMatcher closedRange(int c1, int c2) {
        Validate.requireArgument((c1 | c2 | c2 - c1) >= 0, "illegal range[%d, %d]", c1, c2);
        return c -> c >= c1 && c <= c2;
    }
}

