/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.shaded.json.reader;

import com.nimbusds.jose.shaded.json.JSONAware;
import com.nimbusds.jose.shaded.json.JSONAwareEx;
import com.nimbusds.jose.shaded.json.JSONStreamAware;
import com.nimbusds.jose.shaded.json.JSONStreamAwareEx;
import com.nimbusds.jose.shaded.json.JSONStyle;
import com.nimbusds.jose.shaded.json.JSONValue;
import com.nimbusds.jose.shaded.json.reader.ArrayWriter;
import com.nimbusds.jose.shaded.json.reader.BeansWriter;
import com.nimbusds.jose.shaded.json.reader.BeansWriterASM;
import com.nimbusds.jose.shaded.json.reader.BeansWriterASMRemap;
import com.nimbusds.jose.shaded.json.reader.JsonWriterI;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonWriter {
    private ConcurrentHashMap<Class<?>, JsonWriterI<?>> data = new ConcurrentHashMap();
    private LinkedList<WriterByInterface> writerInterfaces = new LinkedList();
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value2, Appendable out, JSONStyle compression) throws IOException {
            value2.writeJSONString(out);
        }
    };
    public static final JsonWriterI<JSONStreamAwareEx> JSONStreamAwareExWriter = new JsonWriterI<JSONStreamAwareEx>(){

        @Override
        public <E extends JSONStreamAwareEx> void writeJSONString(E value2, Appendable out, JSONStyle compression) throws IOException {
            value2.writeJSONString(out, compression);
        }
    };
    public static final JsonWriterI<JSONAwareEx> JSONJSONAwareExWriter = new JsonWriterI<JSONAwareEx>(){

        @Override
        public <E extends JSONAwareEx> void writeJSONString(E value2, Appendable out, JSONStyle compression) throws IOException {
            out.append(value2.toJSONString(compression));
        }
    };
    public static final JsonWriterI<JSONAware> JSONJSONAwareWriter = new JsonWriterI<JSONAware>(){

        @Override
        public <E extends JSONAware> void writeJSONString(E value2, Appendable out, JSONStyle compression) throws IOException {
            out.append(value2.toJSONString());
        }
    };
    public static final JsonWriterI<Iterable<? extends Object>> JSONIterableWriter = new JsonWriterI<Iterable<? extends Object>>(){

        @Override
        public <E extends Iterable<? extends Object>> void writeJSONString(E list, Appendable out, JSONStyle compression) throws IOException {
            boolean first = true;
            compression.arrayStart(out);
            for (Object value2 : list) {
                if (first) {
                    first = false;
                    compression.arrayfirstObject(out);
                } else {
                    compression.arrayNextElm(out);
                }
                if (value2 == null) {
                    out.append("null");
                } else {
                    JSONValue.writeJSONString(value2, out, compression);
                }
                compression.arrayObjectEnd(out);
            }
            compression.arrayStop(out);
        }
    };
    public static final JsonWriterI<Enum<?>> EnumWriter = new JsonWriterI<Enum<?>>(){

        @Override
        public <E extends Enum<?>> void writeJSONString(E value2, Appendable out, JSONStyle compression) throws IOException {
            String s2 = value2.name();
            compression.writeString(out, s2);
        }
    };
    public static final JsonWriterI<Map<String, ? extends Object>> JSONMapWriter = new JsonWriterI<Map<String, ? extends Object>>(){

        @Override
        public <E extends Map<String, ? extends Object>> void writeJSONString(E map, Appendable out, JSONStyle compression) throws IOException {
            boolean first = true;
            compression.objectStart(out);
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                Object v = entry.getValue();
                if (v == null && compression.ignoreNull()) continue;
                if (first) {
                    compression.objectFirstStart(out);
                    first = false;
                } else {
                    compression.objectNext(out);
                }
                JsonWriter.writeJSONKV(entry.getKey().toString(), v, out, compression);
            }
            compression.objectStop(out);
        }
    };
    public static final JsonWriterI<Object> beansWriterASM = new BeansWriterASM();
    public static final JsonWriterI<Object> beansWriter = new BeansWriter();
    public static final JsonWriterI<Object> arrayWriter = new ArrayWriter();
    public static final JsonWriterI<Object> toStringWriter = new JsonWriterI<Object>(){

        @Override
        public void writeJSONString(Object value2, Appendable out, JSONStyle compression) throws IOException {
            out.append(value2.toString());
        }
    };

    public JsonWriter() {
        this.init();
    }

    public <T> void remapField(Class<T> type, String fromJava, String toJson) {
        JsonWriterI map = this.getWrite(type);
        if (!(map instanceof BeansWriterASMRemap)) {
            map = new BeansWriterASMRemap();
            this.registerWriter(map, type);
        }
        ((BeansWriterASMRemap)map).renameField(fromJava, toJson);
    }

    public JsonWriterI getWriterByInterface(Class<?> clazz) {
        for (WriterByInterface w : this.writerInterfaces) {
            if (!w._interface.isAssignableFrom(clazz)) continue;
            return w._writer;
        }
        return null;
    }

    public JsonWriterI getWrite(Class cls) {
        return this.data.get(cls);
    }

    public void init() {
        this.registerWriter(new JsonWriterI<String>(){

            @Override
            public void writeJSONString(String value2, Appendable out, JSONStyle compression) throws IOException {
                compression.writeString(out, value2);
            }
        }, String.class);
        this.registerWriter(new JsonWriterI<Double>(){

            @Override
            public void writeJSONString(Double value2, Appendable out, JSONStyle compression) throws IOException {
                if (value2.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value2.toString());
                }
            }
        }, Double.class);
        this.registerWriter(new JsonWriterI<Date>(){

            @Override
            public void writeJSONString(Date value2, Appendable out, JSONStyle compression) throws IOException {
                out.append('\"');
                JSONValue.escape(value2.toString(), out, compression);
                out.append('\"');
            }
        }, Date.class);
        this.registerWriter(new JsonWriterI<Float>(){

            @Override
            public void writeJSONString(Float value2, Appendable out, JSONStyle compression) throws IOException {
                if (value2.isInfinite()) {
                    out.append("null");
                } else {
                    out.append(value2.toString());
                }
            }
        }, Float.class);
        this.registerWriter(toStringWriter, Integer.class, Long.class, Byte.class, Short.class, BigInteger.class, BigDecimal.class);
        this.registerWriter(toStringWriter, Boolean.class);
        this.registerWriter(new JsonWriterI<int[]>(){

            @Override
            public void writeJSONString(int[] value2, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (int b : value2) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Integer.toString(b));
                }
                compression.arrayStop(out);
            }
        }, int[].class);
        this.registerWriter(new JsonWriterI<short[]>(){

            @Override
            public void writeJSONString(short[] value2, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (short b : value2) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Short.toString(b));
                }
                compression.arrayStop(out);
            }
        }, short[].class);
        this.registerWriter(new JsonWriterI<long[]>(){

            @Override
            public void writeJSONString(long[] value2, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (long b : value2) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Long.toString(b));
                }
                compression.arrayStop(out);
            }
        }, long[].class);
        this.registerWriter(new JsonWriterI<float[]>(){

            @Override
            public void writeJSONString(float[] value2, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (float b : value2) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Float.toString(b));
                }
                compression.arrayStop(out);
            }
        }, float[].class);
        this.registerWriter(new JsonWriterI<double[]>(){

            @Override
            public void writeJSONString(double[] value2, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (double b : value2) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Double.toString(b));
                }
                compression.arrayStop(out);
            }
        }, double[].class);
        this.registerWriter(new JsonWriterI<boolean[]>(){

            @Override
            public void writeJSONString(boolean[] value2, Appendable out, JSONStyle compression) throws IOException {
                boolean needSep = false;
                compression.arrayStart(out);
                for (boolean b : value2) {
                    if (needSep) {
                        compression.objectNext(out);
                    } else {
                        needSep = true;
                    }
                    out.append(Boolean.toString(b));
                }
                compression.arrayStop(out);
            }
        }, boolean[].class);
        this.registerWriterInterface(JSONStreamAwareEx.class, JSONStreamAwareExWriter);
        this.registerWriterInterface(JSONStreamAware.class, JSONStreamAwareWriter);
        this.registerWriterInterface(JSONAwareEx.class, JSONJSONAwareExWriter);
        this.registerWriterInterface(JSONAware.class, JSONJSONAwareWriter);
        this.registerWriterInterface(Map.class, JSONMapWriter);
        this.registerWriterInterface(Iterable.class, JSONIterableWriter);
        this.registerWriterInterface(Enum.class, EnumWriter);
        this.registerWriterInterface(Number.class, toStringWriter);
    }

    public void addInterfaceWriterFirst(Class<?> interFace, JsonWriterI<?> writer) {
        this.registerWriterInterfaceFirst(interFace, writer);
    }

    public void addInterfaceWriterLast(Class<?> interFace, JsonWriterI<?> writer) {
        this.registerWriterInterfaceLast(interFace, writer);
    }

    public void registerWriterInterfaceLast(Class<?> interFace, JsonWriterI<?> writer) {
        this.writerInterfaces.addLast(new WriterByInterface(interFace, writer));
    }

    public void registerWriterInterfaceFirst(Class<?> interFace, JsonWriterI<?> writer) {
        this.writerInterfaces.addFirst(new WriterByInterface(interFace, writer));
    }

    public void registerWriterInterface(Class<?> interFace, JsonWriterI<?> writer) {
        this.registerWriterInterfaceLast(interFace, writer);
    }

    public <T> void registerWriter(JsonWriterI<T> writer, Class<?> ... cls) {
        for (Class<?> c : cls) {
            this.data.put(c, writer);
        }
    }

    public static void writeJSONKV(String key, Object value2, Appendable out, JSONStyle compression) throws IOException {
        if (key == null) {
            out.append("null");
        } else if (!compression.mustProtectKey(key)) {
            out.append(key);
        } else {
            out.append('\"');
            JSONValue.escape(key, out, compression);
            out.append('\"');
        }
        compression.objectEndOfKey(out);
        if (value2 instanceof String) {
            compression.writeString(out, (String)value2);
        } else {
            JSONValue.writeJSONString(value2, out, compression);
        }
        compression.objectElmStop(out);
    }

    static class WriterByInterface {
        public Class<?> _interface;
        public JsonWriterI<?> _writer;

        public WriterByInterface(Class<?> _interface, JsonWriterI<?> _writer) {
            this._interface = _interface;
            this._writer = _writer;
        }
    }
}

