/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight;

public class BitUtils {
    public static void setBit(byte[] output, int bitno) throws ArrayIndexOutOfBoundsException {
        int index = bitno / 8;
        int index_bitno = bitno % 8;
        byte mask = (byte)(128 >>> index_bitno);
        int n = index;
        output[n] = (byte)(output[n] | mask);
    }

    public static int copyBits(int input, int in_noLSB, byte[] output, int out_pos) {
        int value2 = input;
        int mask = 1 << in_noLSB - 1;
        for (int i = 0; i < in_noLSB; ++i) {
            int res = value2 & mask;
            if (res > 0) {
                BitUtils.setBit(output, out_pos);
            }
            mask >>>= 1;
            ++out_pos;
        }
        return out_pos;
    }

    public static int getBit(byte[] input, int bitno) throws ArrayIndexOutOfBoundsException {
        int index = bitno / 8;
        byte onebyte = input[index];
        int index_bitno = bitno % 8;
        byte mask = (byte)(128 >>> index_bitno);
        int res = onebyte & mask;
        if (res < 0) {
            res = 1;
        }
        return res;
    }

    public static short copyBits(byte[] input, int in_pos, int no_bits) {
        short out_value = 0;
        int out_value_mask = 1 << no_bits - 1;
        for (int b = 0; b < no_bits; ++b) {
            int myBit = BitUtils.getBit(input, in_pos);
            if (myBit > 0) {
                out_value = (short)(out_value | out_value_mask);
            }
            ++in_pos;
            out_value_mask = (short)(out_value_mask >>> 1);
        }
        return out_value;
    }
}

