/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight;

import com.phono.srtplight.InvalidRTCPPacketException;
import com.phono.srtplight.Log;
import com.phono.srtplight.RTCP;
import com.phono.srtplight.RTPPacketException;
import com.phono.srtplight.SRTCPSecContext;
import com.phono.srtplight.SRTPProtocolImpl;
import com.phono.srtplight.SRTPSecContext;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Properties;
import javax.crypto.Mac;

public class SRTCPProtocolImpl {
    static final int AUTHLEN = 10;
    static final int CLEARHEAD = 8;
    static final int MIKEY = 0;
    static final int INDEXLEN = 4;
    private SRTPSecContext _scOut;
    private SRTPSecContext _scIn;
    private boolean _doCrypt = true;
    private boolean _doAuth = true;
    private int _tailIn;
    private int _tailOut;
    private DatagramSocket outDs;
    private int out_index;

    public SRTCPProtocolImpl(Properties l, Properties r) {
        this.init(l, r);
    }

    private void init(Properties lcryptoProps, Properties rcryptoProps) {
        this._scOut = null;
        this._scIn = null;
        try {
            if (this._doAuth || this._doCrypt) {
                this._scIn = new SRTCPSecContext(true);
                this._scIn.parseCryptoProps(rcryptoProps);
                this._tailIn = this._scIn.getAuthTail();
                this._scOut = new SRTCPSecContext(false);
                this._scOut.parseCryptoProps(lcryptoProps);
                this._tailOut = this._scOut.getAuthTail();
            }
        }
        catch (GeneralSecurityException ex) {
            Log.error(" error in constructor " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void sendSR(long ssrc, long ntp, long stamp, long pkts, long octs) throws IOException, GeneralSecurityException {
        RTCP.SenderReport sr = RTCP.mkSenderReport();
        sr.setNTPStamp(ntp);
        sr.setRTPStamp(stamp);
        sr.setSSRC(ssrc);
        sr.setSenderOctets(octs);
        sr.setSenderPackets(pkts);
        Log.verb("RTCP about to build " + sr);
        this.outbound(sr);
    }

    public void sendPLI(long ssrc) throws IOException, GeneralSecurityException {
        byte[] fci = new byte[]{};
        this.sendPSFB(fci, ssrc, 1);
    }

    public void sendPSFB(byte[] fci, long ssrc, int fmt) throws IOException, GeneralSecurityException {
        RTCP.PSFB sr = RTCP.mkPSFB();
        sr.setMssrc(ssrc);
        sr.setFmt(fmt);
        sr.setSssrc(ssrc);
        sr.setSSRC(ssrc);
        sr.setFci(fci);
        Log.info("RTCP about to build " + sr);
        this.outbound(sr);
    }

    public void sendRR() throws IOException, GeneralSecurityException {
        RTCP.ReceiverReport rr = RTCP.mkReceiverReport();
        rr.setSSRC(1L);
        Log.verb("RTCP about to build " + rr);
        this.outbound(rr);
    }

    private void outbound(RTCP rtcp) throws IOException, GeneralSecurityException {
        int ebl = rtcp.estimateBodyLength();
        int fpl = 4 * (ebl + 1) + 4 + this._tailOut;
        ByteBuffer bbo = ByteBuffer.allocate(fpl);
        rtcp.addBody(bbo);
        Log.verb("RTCP built " + rtcp);
        Log.verb("packet body " + SRTPProtocolImpl.getHex(bbo.array()));
        this.encrypt(bbo, this.out_index, (int)rtcp.ssrc);
        Log.verb("RTCP encrypted " + rtcp);
        Log.verb("packet body " + SRTPProtocolImpl.getHex(bbo.array()));
        bbo.putInt(Integer.MIN_VALUE | Integer.MAX_VALUE & this.out_index);
        Log.verb("RTCP added index " + rtcp);
        Log.verb("packet body " + SRTPProtocolImpl.getHex(bbo.array()));
        this.appendAuth(bbo);
        Log.verb("RTCP authed " + rtcp);
        Log.verb("packet body " + SRTPProtocolImpl.getHex(bbo.array()));
        byte[] out = bbo.array();
        this.sendToNetwork(out);
        Log.debug("RTCP sent " + rtcp);
        ++this.out_index;
    }

    protected void sendToNetwork(byte[] pay) throws IOException {
        DatagramPacket p = new DatagramPacket(pay, 0, pay.length);
        if (this.outDs != null) {
            this.outDs.send(p);
        } else {
            Log.verb("RTCP Dummy. Wanted to send this " + SRTPProtocolImpl.getHex(p.getData()));
        }
    }

    void checkAuth(byte[] packet, int plen) throws RTPPacketException {
        if (Log.getLevel() > 4) {
            Log.verb("auth on packet " + SRTPProtocolImpl.getHex(packet, plen));
        }
        try {
            this._scIn.deriveKeys(0L);
            if (this._doAuth) {
                Mac hmac = this._scIn.getAuthMac();
                int alen = this._tailIn;
                int offs = plen - alen;
                ByteBuffer m = ByteBuffer.allocate(offs);
                m.put(packet, 0, offs);
                byte[] auth = new byte[alen];
                System.arraycopy(packet, offs, auth, 0, alen);
                int mlen = plen - alen;
                Log.verb("mess length =" + mlen);
                if (Log.getLevel() > 4) {
                    Log.verb("auth body " + SRTPProtocolImpl.getHex(m.array()));
                }
                ((Buffer)m).position(0);
                hmac.update(m);
                byte[] mac = hmac.doFinal();
                if (Log.getLevel() > 4) {
                    Log.verb("auth in   " + SRTPProtocolImpl.getHex(auth));
                }
                if (Log.getLevel() > 4) {
                    Log.verb("auth out  " + SRTPProtocolImpl.getHex(mac, alen));
                }
                for (int i = 0; i < alen; ++i) {
                    if (auth[i] == mac[i]) continue;
                    throw new RTPPacketException("not authorized byte " + i + " does not match ");
                }
                Log.verb("RTCP auth ok");
            }
        }
        catch (GeneralSecurityException ex) {
            Log.debug("RTCP auth check failed " + ex.getMessage());
            throw new RTPPacketException("Problem checking  packet " + ex.getMessage());
        }
    }

    void appendAuth(ByteBuffer m) throws RTPPacketException, GeneralSecurityException {
        Mac mac = this._scOut.getAuthMac();
        ByteBuffer bm = m;
        int top = bm.limit();
        ((Buffer)bm).position(0);
        int authLoc = top - this._tailOut;
        ((Buffer)bm).limit(authLoc);
        mac.update(m);
        byte[] auth = mac.doFinal();
        ((Buffer)bm).limit(top);
        ((Buffer)bm).position(authLoc);
        m.put(auth, 0, this._tailOut);
        ((Buffer)bm).position(0);
        if (Log.getLevel() > 4) {
            Log.verb("Authed packet " + SRTPProtocolImpl.getHex(m.array()));
        }
    }

    public RTCP[] inbound(DatagramPacket pkt) throws InvalidRTCPPacketException, RTPPacketException, GeneralSecurityException {
        ArrayList<RTCP> rtcps = new ArrayList<RTCP>();
        int len = pkt.getLength();
        byte[] data = new byte[len];
        System.arraycopy(pkt.getData(), 0, data, 0, len);
        Log.verb("RTCP packet " + SRTPProtocolImpl.getHex(data));
        ByteBuffer bb = ByteBuffer.wrap(data);
        char fh = bb.getChar();
        int v = (fh & 0xC000) >>> 14;
        int p = (fh & 0x2000) >>> 13;
        int rc = (fh & 0x1F00) >>> 8;
        char pt = (char)(fh & 0xFF);
        char length = bb.getChar();
        int ssrc = bb.getInt();
        int tail_len = 14;
        int tail_offset = len - tail_len;
        byte[] authtag = new byte[10];
        byte[] mikey = new byte[]{};
        ByteBuffer bbb = bb;
        ((Buffer)bbb).position(tail_offset);
        long index = bb.getInt();
        boolean encryption = index < 0L;
        index = Integer.MAX_VALUE & index;
        bb.get(authtag);
        Log.verb("Tail =" + tail_len + " index=" + index + " mkti=" + SRTPProtocolImpl.getHex(mikey) + " authtag=" + SRTPProtocolImpl.getHex(authtag) + " encryption=" + encryption);
        ((Buffer)bbb).position(0);
        if (encryption) {
            this._scIn.deriveKeys(index);
            this.checkAuth(data, len);
            ((Buffer)bbb).position(0);
            this.decrypt(bb, len, tail_len, ssrc, index);
            ((Buffer)bbb).position(0);
            while (bb.remaining() >= 8 + tail_len) {
                Log.verb("RTCP packet starts at " + bbb.position());
                RTCP rtcp = RTCP.mkRTCP(bb);
                Log.verb("RTCP packet was: " + rtcp.toString());
                rtcps.add(rtcp);
            }
        }
        RTCP[] ret = new RTCP[rtcps.size()];
        int i = 0;
        for (RTCP rtcp : rtcps) {
            ret[i++] = rtcp;
        }
        return ret;
    }

    void decrypt(ByteBuffer pkt, int len, int tail_len, int ssrc, long index) throws GeneralSecurityException {
        int plen = len - tail_len - 8;
        byte[] payload = new byte[plen];
        Log.verb("pkt remains " + pkt.remaining() + " offset 8 plen " + plen);
        for (int i = 0; i < plen; ++i) {
            payload[i] = pkt.get(i + 8);
        }
        ByteBuffer in = ByteBuffer.wrap(payload);
        int pl = (payload.length / 32 + 2) * 32;
        ByteBuffer out = ByteBuffer.allocate(pl);
        ByteBuffer pepper = SRTPProtocolImpl.getPepper(ssrc, index);
        this._scIn.decipher(in, out, pepper);
        for (int i = 0; i < payload.length; ++i) {
            pkt.put(i + 8, out.get(i));
        }
    }

    public static void main(String[] args) {
        Log.setLevel(9);
        try {
            short[] testPacketS = new short[]{129, 201, 0, 7, 0, 0, 0, 1, 212, 103, 248, 51, 115, 215, 197, 216, 99, 79, 130, 116, 113, 10, 28, 1, 31, 164, 169, 5, 51, 64, 43, 103, 123, 136, 139, 78, 108, 254, 51, 210, 223, 40, 2, 210, 71, 111, 28, 40, 26, 37, 196, 164, 245, 6, 38, 159, 121, 215, 123, 148, 119, 214, 72, 48, 203, 49, 215, 122, 128, 0, 0, 30, 157, 162, 108, 241, 131, 241, 151, 132, 125, 45};
            byte[] testpacket = SRTPSecContext.saba(testPacketS);
            Properties r = new Properties();
            r.load(new StringReader("crypto-suite=AES_CM_128_HMAC_SHA1_80\nrequired=1\nkey-params=inline:IzdXQaD4zH55rctZ8O+0ip3nX+FKXmuJKgmudPej\n"));
            Properties l = new Properties();
            l.load(new StringReader("crypto-suite=AES_CM_128_HMAC_SHA1_80\nrequired=1\nkey-params=inline:rpKkWGtGVlqxzzFSaR26P+e1UAC4AduIhJSsNTOK\n"));
            SRTCPProtocolImpl testMe = new SRTCPProtocolImpl(r, r);
            DatagramPacket pkt = new DatagramPacket(testpacket, testpacket.length);
            Log.debug("----------> fake inbound packet");
            testMe.inbound(pkt);
            Log.debug("----------> verify appendAuth mechanism");
            ByteBuffer va = ByteBuffer.wrap(testpacket);
            Log.debug("Before Auth: " + SRTPProtocolImpl.getHex(va.array()));
            testMe._scOut.deriveKeys(0L);
            testMe.appendAuth(va);
            Log.debug("After  Auth: " + SRTPProtocolImpl.getHex(va.array()));
            Log.debug("----------> fake outbound packet");
            testMe.out_index = 0x777777;
            testMe.sendSR(0x53535353L, 1500L, 0L, 1L, 1408L);
            testMe.sendRR();
        }
        catch (Throwable t) {
            Log.error("Thrown " + t.getMessage());
            t.printStackTrace();
        }
    }

    public void setDS(DatagramSocket ds) {
        this.outDs = ds;
    }

    private void encrypt(ByteBuffer bbo, long idx, int ssrc) throws GeneralSecurityException {
        this._scOut.deriveKeys(idx);
        ByteBuffer bbbo = bbo;
        int pos = bbbo.position();
        int paylen = pos - 8;
        int pl = (paylen / 32 + 2) * 32;
        byte[] bin = new byte[paylen];
        ((Buffer)bbbo).position(8);
        bbo.get(bin, 0, paylen);
        ByteBuffer in = ByteBuffer.wrap(bin);
        ByteBuffer out = ByteBuffer.allocate(pl);
        ByteBuffer pepper = SRTPProtocolImpl.getPepper(ssrc, idx);
        this._scOut.decipher(in, out, pepper);
        ((Buffer)bbbo).position(8);
        bbo.put(out.array(), 0, paylen);
        ((Buffer)bbbo).position(pos);
    }
}

