/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight.rtcp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class CCFB {
    public static final int FMT = 11;
    List<CCFBStream> streams = new ArrayList<CCFBStream>();
    final long reportTime;

    public CCFB(long ssrc1, byte[] fci) {
        ByteBuffer bb = ByteBuffer.wrap(fci);
        long s2 = ssrc1;
        while (bb.hasRemaining()) {
            char beginSeq = bb.getChar();
            int nreps = bb.getChar();
            CCFBReport[] rs = new CCFBReport[nreps];
            for (int n = 0; n < nreps; ++n) {
                char v = bb.getChar();
                rs[n] = new CCFBReport(v);
            }
            if (nreps % 2 == 1) {
                bb.getChar();
            }
            this.streams.add(new CCFBStream(s2, beginSeq, rs));
            s2 = bb.getInt();
        }
        this.reportTime = s2;
    }

    public String toString() {
        StringBuffer srs = new StringBuffer();
        this.streams.stream().forEach(s2 -> srs.append(s2.toString()).append("\n"));
        return "CCFB at " + this.reportTime + " contains " + srs;
    }

    class CCFBStream {
        final long ssrc;
        final char seq;
        final CCFBReport[] reports;

        CCFBStream(long ssrc, char beginSeq, CCFBReport[] reports) {
            this.reports = reports;
            this.seq = beginSeq;
            this.ssrc = ssrc;
        }

        public String toString() {
            StringBuffer reps = new StringBuffer();
            for (CCFBReport r : this.reports) {
                reps.append(r.toString()).append("\n\t");
            }
            return "ssrc=" + this.ssrc + " seq=" + ('\u0000' + this.seq) + " reports " + reps;
        }
    }

    class CCFBReport {
        final boolean recvd;
        final int ecn;
        final long timeOffset;

        CCFBReport(char c) {
            this.recvd = (c & 0x8000) != 0;
            this.ecn = (c & 0x6000) >> 13;
            this.timeOffset = c & 0x3FFF;
        }

        public String toString() {
            return "recvd =" + this.recvd + " ecn=" + this.ecn + " timeOffset=" + this.timeOffset;
        }
    }
}

