/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight.rtcp;

import com.phono.srtplight.BitUtils;
import com.phono.srtplight.Log;
import com.phono.srtplight.SRTPProtocolImpl;
import java.nio.ByteBuffer;

public class REMB {
    public static int FMT = 15;

    public static long getBwe(byte[] fci) {
        long bwe = 0L;
        int remb = 1380273474;
        if (fci.length >= 12) {
            ByteBuffer bb = ByteBuffer.wrap(fci);
            int sig = bb.getInt();
            int val = bb.getInt();
            int ssrc = bb.getInt();
            if (sig == remb) {
                Log.verb("got remb data");
                int mant = val & 0x3FFFF;
                int exp = (val & 0xFC0000) >> 18;
                int ssrcn = (val & 0xF0000000) >> 24;
                bwe = mant << exp;
                Log.verb("bwe =" + bwe + " mant =" + mant + " exp=" + exp + " srcn=" + ssrcn + " ssrc = " + ssrc);
            } else {
                Log.warn("not remb");
            }
        }
        return bwe;
    }

    public static byte[] makeBwe(long bwe, long ssrc) {
        byte[] fci = new byte[12];
        byte[] sig = new byte[]{82, 69, 77, 66};
        int offs = 0;
        for (byte v : sig) {
            fci[offs++] = v;
        }
        int topBit = 31;
        while ((bwe & (long)(1 << topBit)) == 0L) {
            --topBit;
        }
        if (topBit < 17) {
            topBit = 17;
        }
        int exp = topBit - 17;
        Log.info("exp = " + exp);
        int mant = (int)(bwe >>> exp);
        Log.info("mant = " + mant);
        int sn = 1;
        BitUtils.copyBits(sn, 8, fci, 32);
        BitUtils.copyBits(exp, 6, fci, 40);
        BitUtils.copyBits(mant, 18, fci, 46);
        BitUtils.copyBits((int)ssrc, 32, fci, 64);
        return fci;
    }

    public static final void main(String[] argv) {
        Log.setLevel(9);
        long[] ts = new long[]{50000L, 128000L, 512000L, 750000L, 2111000L, 3333333L, 10000000L};
        byte[] tb1 = new byte[]{82, 69, 77, 66, 1, 19, 18, 117, 79, 93, -92, 15};
        long t1 = REMB.getBwe(tb1);
        Log.info("t1 =" + t1);
        byte[] fci = REMB.makeBwe(t1, 1331536911L);
        Log.info("Fci is " + SRTPProtocolImpl.getHex(fci));
        long t2 = REMB.getBwe(fci);
        Log.info("t2 =" + t2);
        for (long t : ts) {
            byte[] f = REMB.makeBwe(t, 1331536911L);
            long ta = REMB.getBwe(f);
            Log.info("t=" + t + " ta=" + ta);
        }
    }
}

