/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import java.math.BigInteger;
import java.util.Random;
import java.util.UUID;

public class ExpandedSessionInfo
extends SessionInfo {
    private static final Random RANDOM = new Random();
    private String connectionId;
    private String xuid;
    private String rakNetGUID;
    private String sessionId;
    private String handleId;
    private BigInteger netherNetId;
    private String deviceId;

    ExpandedSessionInfo(String connectionId, String xuid, SessionInfo sessionInfo) {
        this.connectionId = connectionId;
        this.xuid = xuid;
        this.rakNetGUID = "";
        this.sessionId = UUID.randomUUID().toString();
        this.netherNetId = BigInteger.valueOf(Math.abs(RANDOM.nextLong()));
        this.deviceId = UUID.randomUUID().toString();
        this.setHostName(sessionInfo.getHostName().isEmpty() ? "MCXboxBroadcast" : sessionInfo.getHostName());
        this.setWorldName(sessionInfo.getWorldName().isEmpty() ? this.getHostName() : sessionInfo.getWorldName());
        this.setPlayers(sessionInfo.getPlayers());
        this.setMaxPlayers(sessionInfo.getMaxPlayers());
        this.setIp(sessionInfo.getIp());
        this.setPort(sessionInfo.getPort());
    }

    public void updateSessionInfo(SessionInfo sessionInfo) {
        this.setHostName(sessionInfo.getHostName().isEmpty() ? "MCXboxBroadcast" : sessionInfo.getHostName());
        this.setWorldName(sessionInfo.getWorldName().isEmpty() ? this.getHostName() : sessionInfo.getWorldName());
        this.setPlayers(sessionInfo.getPlayers());
        this.setMaxPlayers(sessionInfo.getMaxPlayers());
        this.setIp(sessionInfo.getIp());
        this.setPort(sessionInfo.getPort());
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getXuid() {
        return this.xuid;
    }

    public void setXuid(String xuid) {
        this.xuid = xuid;
    }

    public String getRakNetGUID() {
        return this.rakNetGUID;
    }

    public void setRakNetGUID(String rakNetGUID) {
        this.rakNetGUID = rakNetGUID;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public BigInteger getNetherNetId() {
        return this.netherNetId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getHandleId() {
        return this.handleId;
    }

    public void setHandleId(String handleId) {
        this.handleId = handleId;
    }
}

