/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.ExpandedSessionInfo;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.SubSessionManager;
import com.rtm516.mcxboxbroadcast.core.configs.FriendSyncConfig;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionCreationException;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionUpdateException;
import com.rtm516.mcxboxbroadcast.core.models.session.CreateSessionRequest;
import com.rtm516.mcxboxbroadcast.core.models.session.CreateSessionResponse;
import com.rtm516.mcxboxbroadcast.core.notifications.NotificationManager;
import com.rtm516.mcxboxbroadcast.core.storage.StorageManager;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.java_websocket.util.NamedThreadFactory;

public class SessionManager
extends SessionManagerCore {
    private final ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(5, new NamedThreadFactory("MCXboxBroadcast Thread"));
    private final Map<String, SubSessionManager> subSessionManagers = new HashMap<String, SubSessionManager>();
    private FriendSyncConfig friendSyncConfig;
    private Runnable restartCallback;

    public SessionManager(StorageManager storageManager, NotificationManager notificationManager, Logger logger) {
        super(storageManager, notificationManager, logger.prefixed("Primary Session"));
    }

    @Override
    public ScheduledExecutorService scheduledThread() {
        return this.scheduledThreadPool;
    }

    @Override
    public String getSessionId() {
        return this.sessionInfo.getSessionId();
    }

    public ExpandedSessionInfo sessionInfo() {
        return this.sessionInfo;
    }

    public void init(SessionInfo sessionInfo, FriendSyncConfig friendSyncConfig) throws SessionCreationException, SessionUpdateException {
        this.sessionInfo = new ExpandedSessionInfo("", "", sessionInfo);
        super.init();
        if (friendSyncConfig.updateInterval() < 20) {
            this.logger.warn("Friend sync update interval is less than 20 seconds, setting to 20 seconds");
            friendSyncConfig = new FriendSyncConfig(20, friendSyncConfig.autoFollow(), friendSyncConfig.autoUnfollow(), friendSyncConfig.initialInvite(), friendSyncConfig.shouldExpire(), friendSyncConfig.expireDays(), friendSyncConfig.expireCheck());
        }
        this.friendSyncConfig = friendSyncConfig;
        this.friendManager().init(this.friendSyncConfig);
        List<Object> subSessions = new ArrayList();
        try {
            String subSessionsJson = this.storageManager().subSessions();
            if (!subSessionsJson.isBlank()) {
                subSessions = Arrays.asList(Constants.GSON.fromJson(subSessionsJson, String[].class));
            }
        }
        catch (IOException subSessionsJson) {
            // empty catch block
        }
        ArrayList finalSubSessions = subSessions;
        this.scheduledThreadPool.execute(() -> {
            for (String subSession : finalSubSessions) {
                try {
                    SubSessionManager subSessionManager = new SubSessionManager(subSession, this, this.storageManager().subSession(subSession), this.notificationManager(), this.logger);
                    subSessionManager.init();
                    subSessionManager.friendManager().init(this.friendSyncConfig);
                    this.subSessionManagers.put(subSession, subSessionManager);
                }
                catch (SessionCreationException | SessionUpdateException e) {
                    this.logger.error("Failed to create sub-session " + subSession, e);
                }
            }
        });
    }

    @Override
    protected boolean handleFriendship() {
        return false;
    }

    public void updateSession(SessionInfo sessionInfo) throws SessionUpdateException {
        this.sessionInfo.updateSessionInfo(sessionInfo);
        this.updateSession();
    }

    @Override
    protected void updateSession() throws SessionUpdateException {
        this.checkConnection();
        String responseBody = super.updateSessionInternal("https://sessiondirectory.xboxlive.com/serviceconfigs/4fc10100-5f7a-4470-899b-280835760c07/sessionTemplates/MinecraftLobby/sessions/%s".formatted(this.sessionInfo.getSessionId()), new CreateSessionRequest(this.sessionInfo));
        try {
            CreateSessionResponse sessionResponse = Constants.GSON.fromJson(responseBody, CreateSessionResponse.class);
            int players = sessionResponse.members().size();
            if (players >= 28) {
                this.logger.info("Restarting session due to " + players + "/30 players");
                this.restart();
            }
        }
        catch (JsonParseException e) {
            throw new SessionUpdateException("Failed to parse session response: " + e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        for (SubSessionManager subSessionManager : this.subSessionManagers.values()) {
            subSessionManager.shutdown();
        }
        super.shutdown();
        this.scheduledThreadPool.shutdownNow();
    }

    public void dumpSession() {
        try {
            this.storageManager().lastSessionResponse(this.lastSessionResponse);
        }
        catch (IOException e) {
            this.logger.error("Error dumping last session: " + e.getMessage());
        }
        HttpRequest createSessionRequest = HttpRequest.newBuilder().uri(URI.create("https://sessiondirectory.xboxlive.com/serviceconfigs/4fc10100-5f7a-4470-899b-280835760c07/sessionTemplates/MinecraftLobby/sessions/%s".formatted(this.sessionInfo.getSessionId()))).header("Content-Type", "application/json").header("Authorization", this.getTokenHeader()).header("x-xbl-contract-version", "107").GET().build();
        try {
            HttpResponse<String> createSessionResponse = this.httpClient.send(createSessionRequest, HttpResponse.BodyHandlers.ofString());
            this.storageManager().currentSessionResponse(createSessionResponse.body());
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Error dumping current session: " + e.getMessage());
        }
    }

    public void addSubSession(String id) {
        if (this.subSessionManagers.containsKey(id)) {
            this.coreLogger.error("Sub-session already exists with that ID");
            return;
        }
        try {
            SubSessionManager subSessionManager = new SubSessionManager(id, this, this.storageManager().subSession(id), this.notificationManager(), this.logger);
            subSessionManager.init();
            subSessionManager.friendManager().init(this.friendSyncConfig);
            this.subSessionManagers.put(id, subSessionManager);
        }
        catch (SessionCreationException | SessionUpdateException e) {
            this.coreLogger.error("Failed to create sub-session", e);
            return;
        }
        try {
            this.storageManager().subSessions(Constants.GSON.toJson(this.subSessionManagers.keySet()));
        }
        catch (JsonParseException | IOException e) {
            this.coreLogger.error("Failed to update sub-session list", e);
        }
    }

    public void removeSubSession(String id) {
        if (!this.subSessionManagers.containsKey(id)) {
            this.coreLogger.error("Sub-session does not exist with that ID");
            return;
        }
        this.subSessionManagers.get(id).shutdown();
        this.subSessionManagers.remove(id);
        try {
            this.storageManager().subSession(id).cleanup();
        }
        catch (IOException e) {
            this.coreLogger.error("Failed to delete sub-session cache file", e);
        }
        try {
            this.storageManager().subSessions(Constants.GSON.toJson(this.subSessionManagers.keySet()));
        }
        catch (JsonParseException | IOException e) {
            this.coreLogger.error("Failed to update sub-session list", e);
        }
        this.coreLogger.info("Removed sub-session with ID " + id);
    }

    public void listSessions() {
        ArrayList<Object> messages = new ArrayList<Object>();
        this.coreLogger.info("Loading status of sessions...");
        messages.add("Primary Session:");
        messages.add(" - Gamertag: " + this.getXboxToken().gamertag());
        messages.add("   Following: " + this.socialSummary().targetFollowingCount() + "/2000");
        if (!this.subSessionManagers.isEmpty()) {
            messages.add("Sub-sessions: (" + this.subSessionManagers.size() + ")");
            for (Map.Entry entry : this.subSessionManagers.entrySet()) {
                messages.add(" - ID: " + (String)entry.getKey());
                messages.add("   Gamertag: " + ((SubSessionManager)entry.getValue()).getXboxToken().gamertag());
                messages.add("   Following: " + ((SubSessionManager)entry.getValue()).socialSummary().targetFollowingCount() + "/2000");
            }
        } else {
            messages.add("No sub-sessions");
        }
        for (String string : messages) {
            this.coreLogger.info(string);
        }
    }

    public void restartCallback(Runnable restart) {
        this.restartCallback = restart;
    }

    public void restart() {
        if (this.restartCallback != null) {
            this.restartCallback.run();
        } else {
            this.logger.error("No restart callback set");
        }
    }

    public String getGamertag() {
        return this.getXboxToken().gamertag();
    }

    public String getXuid() {
        return this.getXboxToken().userXUID();
    }
}

