/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core;

import com.github.mizosoft.methanol.Methanol;
import com.rtm516.mcxboxbroadcast.core.AuthManager;
import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.ExpandedSessionInfo;
import com.rtm516.mcxboxbroadcast.core.FriendManager;
import com.rtm516.mcxboxbroadcast.core.GalleryManager;
import com.rtm516.mcxboxbroadcast.core.IceLoggerDisabler;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.RtaWebsocketClient;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionCreationException;
import com.rtm516.mcxboxbroadcast.core.exceptions.SessionUpdateException;
import com.rtm516.mcxboxbroadcast.core.models.auth.SessionStartBody;
import com.rtm516.mcxboxbroadcast.core.models.auth.SessionStartResponse;
import com.rtm516.mcxboxbroadcast.core.models.auth.XboxTokenInfo;
import com.rtm516.mcxboxbroadcast.core.models.other.ProfileSettingsResponse;
import com.rtm516.mcxboxbroadcast.core.models.session.CreateHandleRequest;
import com.rtm516.mcxboxbroadcast.core.models.session.CreateHandleResponse;
import com.rtm516.mcxboxbroadcast.core.models.session.SessionRef;
import com.rtm516.mcxboxbroadcast.core.models.session.SocialSummaryResponse;
import com.rtm516.mcxboxbroadcast.core.notifications.NotificationManager;
import com.rtm516.mcxboxbroadcast.core.storage.StorageManager;
import com.rtm516.mcxboxbroadcast.core.webrtc.RtcWebsocketClient;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SessionManagerCore {
    private final AuthManager authManager;
    private final FriendManager friendManager;
    protected final HttpClient httpClient = ((Methanol.Builder)Methanol.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).requestTimeout(Duration.ofMillis(5000L))).build();
    protected final Logger logger;
    protected final Logger coreLogger;
    private final StorageManager storageManager;
    private final NotificationManager notificationManager;
    private final GalleryManager galleryManager;
    protected RtaWebsocketClient rtaWebsocket;
    protected ExpandedSessionInfo sessionInfo;
    protected String lastSessionResponse;
    protected boolean initialized = false;
    private RtcWebsocketClient rtcWebsocket;
    private String mcToken;

    public SessionManagerCore(StorageManager storageManager, NotificationManager notificationManager, Logger logger) {
        this.logger = logger;
        this.coreLogger = logger.prefixed("");
        this.storageManager = storageManager;
        this.notificationManager = notificationManager;
        this.authManager = new AuthManager(notificationManager, storageManager, logger);
        this.friendManager = new FriendManager(this.httpClient, logger, this);
        this.galleryManager = new GalleryManager(this.httpClient, logger, this);
        IceLoggerDisabler.disable(logger);
    }

    public FriendManager friendManager() {
        return this.friendManager;
    }

    public NotificationManager notificationManager() {
        return this.notificationManager;
    }

    public GalleryManager galleryManager() {
        return this.galleryManager;
    }

    public abstract ScheduledExecutorService scheduledThread();

    public abstract String getSessionId();

    public Logger logger() {
        return this.logger;
    }

    protected XboxTokenInfo getXboxToken() {
        return this.authManager.getXboxToken();
    }

    public void init() throws SessionCreationException, SessionUpdateException {
        if (this.initialized) {
            throw new SessionCreationException("Already initialized!");
        }
        this.logger.info("Starting SessionManager...");
        XboxTokenInfo tokenInfo = this.getXboxToken();
        int friendCount = -1;
        try {
            friendCount = this.friendManager.get().size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.info("Successfully authenticated as " + tokenInfo.gamertag() + " (" + tokenInfo.userXUID() + ") with " + friendCount + "/2000 friends");
        this.checkGamertagUpdate(tokenInfo);
        if (this.handleFriendship()) {
            this.logger.info("Waiting for friendship to be processed...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                this.logger.error("Failed to wait for friendship to be processed", e);
            }
        }
        this.logger.info("Creating Xbox LIVE session...");
        this.createSession();
        this.updatePresence();
        this.logger.info("Creation of Xbox LIVE session was successful!");
        this.authManager.setOnDeviceTokenRefreshCallback(() -> {
            try {
                this.logger.debug("Device token refreshed, recreating session...");
                this.createSession();
                this.logger.debug("Session recreated after device token refresh");
            }
            catch (Exception e) {
                this.logger.error("Failed to recreate session after device token refresh", e);
            }
        });
        this.initialized = true;
    }

    protected abstract boolean handleFriendship();

    private void createSession() throws SessionCreationException, SessionUpdateException {
        HttpResponse<String> createHandleResponse;
        HttpRequest createHandleRequest;
        XboxTokenInfo tokenInfo = this.getXboxToken();
        String token = tokenInfo.tokenHeader();
        if (this.sessionInfo != null) {
            this.sessionInfo.setXuid(tokenInfo.userXUID());
            this.mcToken = this.setupSession(this.sessionInfo.getDeviceId());
            this.setupRtaWebsocket();
            try {
                String connectionId = this.waitForConnectionId();
                this.sessionInfo.setConnectionId(connectionId);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new SessionCreationException("Unable to get connectionId for session: " + e.getMessage());
            }
            this.setupRtcWebsocket(this.mcToken);
            try {
                this.waitForRTCConnection();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new SessionCreationException("Unable to connect to WebRTC for session: " + e.getMessage());
            }
        }
        this.mcToken = this.setupSession(UUID.randomUUID().toString());
        File imageFile = this.storageManager.screenshot();
        if (imageFile.exists()) {
            this.logger.info("Setting showcase image");
            if (this.galleryManager.setShowcase(imageFile)) {
                this.logger.info("Successfully set showcase image");
            }
        }
        this.updateSession();
        CreateHandleRequest createHandleContent = new CreateHandleRequest(1, "activity", new SessionRef("4fc10100-5f7a-4470-899b-280835760c07", "MinecraftLobby", this.getSessionId()));
        try {
            createHandleRequest = HttpRequest.newBuilder().uri(Constants.CREATE_HANDLE).header("Content-Type", "application/json").header("Authorization", token).header("x-xbl-contract-version", "107").POST(HttpRequest.BodyPublishers.ofString(Constants.GSON.toJson(createHandleContent))).build();
        }
        catch (JsonParseException e) {
            throw new SessionCreationException("Unable to create session handle, error parsing json: " + e.getMessage());
        }
        try {
            createHandleResponse = this.httpClient.send(createHandleRequest, HttpResponse.BodyHandlers.ofString());
            if (this.sessionInfo != null) {
                CreateHandleResponse parsedResponse = Constants.GSON.fromJson(createHandleResponse.body(), CreateHandleResponse.class);
                this.sessionInfo.setHandleId(parsedResponse.id());
            }
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            throw new SessionCreationException(e.getMessage());
        }
        this.lastSessionResponse = createHandleResponse.body();
        if (createHandleResponse.statusCode() != 200 && createHandleResponse.statusCode() != 201) {
            this.logger.debug("Failed to create session handle '" + this.lastSessionResponse + "' (" + createHandleResponse.statusCode() + ")");
            throw new SessionCreationException("Unable to create session handle, got status " + createHandleResponse.statusCode() + " trying to create: " + createHandleResponse.body());
        }
    }

    protected abstract void updateSession() throws SessionUpdateException;

    protected String updateSessionInternal(String url, Object data) throws SessionUpdateException {
        HttpResponse<String> createSessionResponse;
        HttpRequest createSessionRequest;
        try {
            createSessionRequest = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("Authorization", this.getTokenHeader()).header("x-xbl-contract-version", "107").PUT(HttpRequest.BodyPublishers.ofString(Constants.GSON.toJson(data))).build();
        }
        catch (JsonParseException e) {
            throw new SessionUpdateException("Unable to update session information, error parsing json: " + e.getMessage());
        }
        try {
            createSessionResponse = this.httpClient.send(createSessionRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new SessionUpdateException(e.getMessage());
        }
        if (createSessionResponse.statusCode() != 200 && createSessionResponse.statusCode() != 201) {
            this.logger.debug("Got update session response: " + createSessionResponse.body());
            throw new SessionUpdateException("Unable to update session information, got status " + createSessionResponse.statusCode() + " trying to update: " + createSessionResponse.body());
        }
        return createSessionResponse.body();
    }

    protected void checkConnection() {
        boolean rtcIsOpen;
        boolean rtaIsOpen = this.rtaWebsocket != null && this.rtaWebsocket.isOpen();
        boolean bl = rtcIsOpen = this.rtcWebsocket != null && this.rtcWebsocket.isOpen();
        if (!rtaIsOpen || !rtcIsOpen) {
            try {
                this.logger.warn("Connection to websocket lost, re-creating session...");
                this.logger.debug("WebSocket status: RTA Open: " + rtaIsOpen + " RTC Open: " + rtcIsOpen);
                this.createSession();
                this.logger.info("WebSocket session reconnected");
            }
            catch (SessionCreationException | SessionUpdateException e) {
                this.logger.error("Session is dead and hit exception trying to re-create it", e);
            }
        }
    }

    public String getTokenHeader() {
        return this.getXboxToken().tokenHeader();
    }

    protected String waitForConnectionId() throws InterruptedException, ExecutionException, TimeoutException {
        return this.rtaWebsocket.getConnectionIdFuture().get(Constants.WEBSOCKET_CONNECTION_TIMEOUT.toSeconds(), TimeUnit.SECONDS);
    }

    protected void waitForRTCConnection() throws InterruptedException, ExecutionException, TimeoutException {
        this.rtcWebsocket.onOpenFuture().get(Constants.WEBSOCKET_CONNECTION_TIMEOUT.toSeconds(), TimeUnit.SECONDS);
    }

    protected String setupSession(String deviceId) {
        HttpResponse<String> response;
        String playfabTicket = this.authManager.getPlayfabSessionTicket();
        HttpRequest request = HttpRequest.newBuilder(Constants.START_SESSION).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(SessionStartBody.create(deviceId, playfabTicket))).build();
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("Unable to start session", e);
        }
        if (response.statusCode() != 200) {
            this.logger.debug(response.body());
            throw new IllegalStateException("Unable to start session!");
        }
        return Constants.GSON.fromJson(response.body(), SessionStartResponse.class).result().authorizationHeader();
    }

    protected void setupRtaWebsocket() {
        if (this.rtaWebsocket != null) {
            this.rtaWebsocket.close();
        }
        this.rtaWebsocket = new RtaWebsocketClient(this);
        this.rtaWebsocket.connect();
    }

    protected void setupRtcWebsocket(String token) {
        if (this.rtcWebsocket != null) {
            this.rtcWebsocket.close();
        }
        this.rtcWebsocket = new RtcWebsocketClient(token, this.sessionInfo, this.logger, this.scheduledThread(), this);
        this.rtcWebsocket.connect();
    }

    public void shutdown() {
        if (this.rtaWebsocket != null) {
            this.rtaWebsocket.close();
        }
        if (this.rtcWebsocket != null) {
            this.rtcWebsocket.close();
        }
        this.initialized = false;
    }

    protected void updatePresence() {
        HttpRequest updatePresenceRequest = HttpRequest.newBuilder().uri(URI.create("https://userpresence.xboxlive.com/users/xuid(%s)/devices/current/titles/current".formatted(this.getXboxToken().userXUID()))).header("Content-Type", "application/json").header("Authorization", this.getTokenHeader()).header("x-xbl-contract-version", "3").POST(HttpRequest.BodyPublishers.ofString("{\"state\": \"active\"}")).build();
        int heartbeatAfter = 300;
        try {
            HttpResponse<Void> updatePresenceResponse = this.httpClient.send(updatePresenceRequest, HttpResponse.BodyHandlers.discarding());
            if (updatePresenceResponse.statusCode() != 200) {
                this.logger.error("Failed to update presence, got status " + updatePresenceResponse.statusCode());
            } else {
                try {
                    heartbeatAfter = Integer.parseInt(updatePresenceResponse.headers().firstValue("X-Heartbeat-After").orElse("300"));
                }
                catch (NumberFormatException e) {
                    this.logger.debug("Failed to parse heartbeat after header, using default of 300");
                }
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Failed to update presence", e);
        }
        this.logger.debug("Presence update successful, scheduling presence update in " + heartbeatAfter + " seconds");
        this.scheduledThread().schedule(this::updatePresence, (long)heartbeatAfter, TimeUnit.SECONDS);
    }

    public SocialSummaryResponse socialSummary() {
        HttpRequest socialSummaryRequest = HttpRequest.newBuilder().uri(Constants.SOCIAL_SUMMARY).header("Authorization", this.getTokenHeader()).GET().build();
        try {
            return Constants.GSON.fromJson(this.httpClient.send(socialSummaryRequest, HttpResponse.BodyHandlers.ofString()).body(), SocialSummaryResponse.class);
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            this.logger.error("Unable to get current friend count", e);
            return new SocialSummaryResponse(-1, -1, false, false, false, false, "", -1L, -1, "");
        }
    }

    private void checkGamertagUpdate(XboxTokenInfo tokenInfo) {
        try {
            HttpResponse<String> response = this.httpClient.send(HttpRequest.newBuilder().uri(URI.create("https://profile.xboxlive.com/users/xuid(%s)/profile/settings?settings=Gamertag".formatted(tokenInfo.userXUID()))).header("Content-Type", "application/json").header("Authorization", tokenInfo.tokenHeader()).header("x-xbl-contract-version", "3").GET().build(), HttpResponse.BodyHandlers.ofString());
            ProfileSettingsResponse profileSettingsResponse = Constants.GSON.fromJson(response.body(), ProfileSettingsResponse.class);
            if (profileSettingsResponse == null) {
                this.logger.error("Unable to get profile settings (" + response.statusCode() + "): " + response.body());
                return;
            }
            String newGamertag = profileSettingsResponse.profileUsers().get(0).settings().get(0).value();
            if (!newGamertag.equals(tokenInfo.gamertag())) {
                this.logger.info("Gamertag changed from " + tokenInfo.gamertag() + " to " + newGamertag);
                this.authManager.updateGamertag(newGamertag);
            }
        }
        catch (IOException | InterruptedException | NullPointerException e) {
            this.logger.error("Failed to check profile settings", e);
        }
    }

    public String userXUID() {
        return this.getXboxToken().userXUID();
    }

    public String getMCTokenHeader() {
        return this.mcToken;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }
}

