/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.notifications;

import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.configs.NotificationConfig;
import com.rtm516.mcxboxbroadcast.core.notifications.NotificationManager;

public class BaseNotificationManager
implements NotificationManager {
    protected final Logger logger;
    protected final NotificationConfig config;

    public BaseNotificationManager(Logger logger, NotificationConfig config) {
        this.logger = logger;
        this.config = config;
    }

    @Override
    public void sendSessionExpiredNotification(String verificationUri, String userCode) {
        this.sendNotification(this.config.sessionExpiredMessage().formatted(verificationUri, userCode));
    }

    @Override
    public void sendFriendRestrictionNotification(String username, String xuid) {
        this.sendNotification(this.config.friendRestrictionMessage().formatted(username, xuid));
    }

    protected void sendNotification(String message) {
        if (!this.config.enabled()) {
            return;
        }
        throw new UnsupportedOperationException();
    }
}

