/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.ping;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.ping.ClientPingHandler;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonObject;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.RakPing;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.BedrockPong;
import org.java_websocket.util.NamedThreadFactory;

public class PingUtil {
    private static final EventLoopGroup workerEventLoopGroup;
    private static boolean webPingEnabled;

    public static Promise<BedrockPong> ping(InetSocketAddress server, long timeout2, TimeUnit timeUnit) {
        EventLoop eventLoop = workerEventLoopGroup.next();
        Promise<BedrockPong> promise = eventLoop.newPromise();
        PingUtil.raknetPing(server, timeout2, timeUnit).addListener(future -> {
            if (future.isSuccess()) {
                promise.trySuccess((BedrockPong)future.get());
            } else if (webPingEnabled) {
                ((CompletableFuture)PingUtil.webPing(server, timeout2, timeUnit).thenAccept(promise::trySuccess)).exceptionally(e -> {
                    promise.tryFailure((Throwable)e);
                    return null;
                });
            } else {
                promise.tryFailure(future.cause());
            }
        });
        return promise;
    }

    private static Promise<BedrockPong> raknetPing(InetSocketAddress server, long timeout2, TimeUnit timeUnit) {
        EventLoop eventLoop = workerEventLoopGroup.next();
        Promise<BedrockPong> promise = eventLoop.newPromise();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(RakChannelFactory.client(NioDatagramChannel.class))).group(workerEventLoopGroup)).option(RakChannelOption.RAK_GUID, ThreadLocalRandom.current().nextLong())).handler(new ClientPingHandler(promise, timeout2, timeUnit))).bind(0).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<ChannelFuture>)future -> {
            if (future.cause() != null) {
                promise.tryFailure(future.cause());
                future.channel().close();
            } else {
                RakPing ping = new RakPing(System.currentTimeMillis(), server);
                future.channel().writeAndFlush(ping).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future1 -> {
                    if (future1.cause() != null) {
                        promise.tryFailure(future1.cause());
                        future.channel().close();
                    }
                }));
            }
        }));
        return promise;
    }

    private static CompletableFuture<BedrockPong> webPing(InetSocketAddress server, long timeout2, TimeUnit timeUnit) {
        CompletableFuture<BedrockPong> future = new CompletableFuture<BedrockPong>();
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://checker.geysermc.org/ping?hostname=" + server.getHostString() + "&port=" + server.getPort())).build();
        ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).orTimeout(timeout2, timeUnit).thenAccept(response -> {
            if (response.statusCode() != 200) {
                future.completeExceptionally(new Exception("WebAPI: Failed to ping server"));
                return;
            }
            JsonObject data = Constants.GSON.fromJson((String)response.body(), JsonObject.class);
            if (!data.get("success").getAsBoolean()) {
                future.completeExceptionally(new Exception("WebAPI: Server is offline"));
                return;
            }
            BedrockPong pong = Constants.GSON.fromJson(data.getAsJsonObject("ping").get("pong"), BedrockPong.class);
            future.complete(pong);
        })).exceptionally(e -> {
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    public static void setWebPingEnabled(boolean enabled) {
        webPingEnabled = enabled;
    }

    static {
        webPingEnabled = false;
        workerEventLoopGroup = new NioEventLoopGroup(0, new NamedThreadFactory("MCXboxBroadcast Ping Thread"));
    }
}

