/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.storage;

import com.rtm516.mcxboxbroadcast.core.storage.StorageManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class FileStorageManager
implements StorageManager {
    private final String cacheFolder;
    private final String screenshotPath;
    private final StorageManager.PlayerHistoryStorage playerHistoryStorage;

    public FileStorageManager(String cacheFolder, String screenshotPath) {
        this.cacheFolder = cacheFolder;
        this.screenshotPath = screenshotPath;
        try {
            Files.createDirectories(Paths.get(cacheFolder, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create cache folder", e);
        }
        this.playerHistoryStorage = new SqlitePlayerHistoryStorage(Paths.get(cacheFolder, "player_history.db"));
    }

    private String read(String file) throws IOException {
        Path cacheFile = Paths.get(this.cacheFolder, file);
        if (!Files.exists(cacheFile, new LinkOption[0])) {
            return "";
        }
        return Files.readString(cacheFile);
    }

    private void write(String file, String data) throws IOException {
        Path filePath = Paths.get(this.cacheFolder, file);
        if (data == null || data.isBlank()) {
            Files.deleteIfExists(filePath);
            return;
        }
        Files.writeString(filePath, (CharSequence)data, new OpenOption[0]);
    }

    @Override
    public String cache() throws IOException {
        return this.read("cache.json");
    }

    @Override
    public void cache(String data) throws IOException {
        this.write("cache.json", data);
    }

    @Override
    public String subSessions() throws IOException {
        return this.read("sub_sessions.json");
    }

    @Override
    public void subSessions(String data) throws IOException {
        this.write("sub_sessions.json", data);
    }

    @Override
    public String lastSessionResponse() throws IOException {
        return this.read("lastSessionResponse.json");
    }

    @Override
    public void lastSessionResponse(String data) throws IOException {
        this.write("lastSessionResponse.json", data);
    }

    @Override
    public String currentSessionResponse() throws IOException {
        return this.read("currentSessionResponse.json");
    }

    @Override
    public void currentSessionResponse(String data) throws IOException {
        this.write("currentSessionResponse.json", data);
    }

    @Override
    public StorageManager subSession(String id) {
        return new FileStorageManager(Paths.get(this.cacheFolder, id).toString(), this.screenshotPath);
    }

    @Override
    public File screenshot() {
        return new File(this.screenshotPath);
    }

    @Override
    public void cleanup() throws IOException {
        Path cache = Paths.get(this.cacheFolder, new String[0]);
        try (Stream<Path> files = Files.walk(cache, new FileVisitOption[0]);){
            files.map(Path::toFile).forEach(File::delete);
            cache.toFile().delete();
        }
    }

    @Override
    public StorageManager.PlayerHistoryStorage playerHistory() {
        return this.playerHistoryStorage;
    }

    public class SqlitePlayerHistoryStorage
    implements StorageManager.PlayerHistoryStorage {
        private Connection connection;
        private boolean firstRun = false;

        public SqlitePlayerHistoryStorage(Path dbFile) {
            try {
                Class.forName("org.sqlite.JDBC");
                if (!Files.exists(dbFile, new LinkOption[0])) {
                    this.firstRun = true;
                }
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(dbFile));
                try (Statement createPlayersTable = this.connection.createStatement();){
                    createPlayersTable.executeUpdate("CREATE TABLE IF NOT EXISTS players (xuid VARCHAR(32), lastSeen INTEGER, PRIMARY KEY(xuid));");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to setup player history database", e);
            }
        }

        @Override
        public boolean isFirstRun() {
            return this.firstRun;
        }

        @Override
        public void lastSeen(String xuid, Instant lastSeen) throws IOException {
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("INSERT OR REPLACE INTO players (xuid, lastSeen) VALUES ('" + xuid + "', " + lastSeen.getEpochSecond() + ");");
            }
            catch (Exception e) {
                throw new IOException("Failed to update player history for xuid: " + xuid, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Instant lastSeen(String xuid) throws IOException {
            try (Statement statement = this.connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT lastSeen FROM players WHERE xuid = '" + xuid + "';");
                if (resultSet.next()) {
                    long lastSeenEpoch = resultSet.getLong("lastSeen");
                    Instant instant2 = Instant.ofEpochSecond(lastSeenEpoch);
                    return instant2;
                }
                Instant instant = null;
                return instant;
            }
            catch (Exception e) {
                throw new IOException("Failed to retrieve player history for xuid: " + xuid, e);
            }
        }

        @Override
        public void clear(String xuid) throws IOException {
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("DELETE FROM players WHERE xuid = '" + xuid + "';");
            }
            catch (Exception e) {
                throw new IOException("Failed to remove player history for xuid: " + xuid, e);
            }
        }

        @Override
        public Map<String, Instant> all() throws IOException {
            HashMap<String, Instant> hashMap;
            block9: {
                Statement statement = this.connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("SELECT xuid, lastSeen FROM players;");
                    HashMap<String, Instant> playerHistory = new HashMap<String, Instant>();
                    while (resultSet.next()) {
                        String xuid = resultSet.getString("xuid");
                        long lastSeenEpoch = resultSet.getLong("lastSeen");
                        playerHistory.put(xuid, Instant.ofEpochSecond(lastSeenEpoch));
                    }
                    hashMap = playerHistory;
                    if (statement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IOException("Failed to retrieve all player history", e);
                    }
                }
                statement.close();
            }
            return hashMap;
        }
    }
}

