/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DatagramTransport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.ice4j.ice.Component;

public class CustomDatagramTransport
implements DatagramTransport {
    private final int maxMessageSize = 262144;
    private DatagramSocket socket;

    public void init(Component component) {
        this.socket = component.getSocket();
    }

    @Override
    public int getReceiveLimit() {
        return 262144;
    }

    @Override
    public int getSendLimit() {
        return 262144;
    }

    @Override
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        if (this.socket.isClosed()) {
            this.close();
            return -1;
        }
        DatagramPacket packet = new DatagramPacket(buf, off, len);
        this.socket.receive(packet);
        return packet.getLength();
    }

    @Override
    public void send(byte[] buf, int off, int len) throws IOException {
        if (this.socket.isClosed()) {
            this.close();
            return;
        }
        this.socket.send(new DatagramPacket(buf, off, len));
    }

    @Override
    public void close() {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }
}

