/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc;

import com.rtm516.mcxboxbroadcast.core.Constants;
import com.rtm516.mcxboxbroadcast.core.ExpandedSessionInfo;
import com.rtm516.mcxboxbroadcast.core.Logger;
import com.rtm516.mcxboxbroadcast.core.SessionInfo;
import com.rtm516.mcxboxbroadcast.core.SessionManagerCore;
import com.rtm516.mcxboxbroadcast.core.models.ws.WsFromMessage;
import com.rtm516.mcxboxbroadcast.core.models.ws.WsToMessage;
import com.rtm516.mcxboxbroadcast.core.webrtc.PeerSession;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonArray;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonElement;
import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonObject;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.math.BigInteger;
import java.net.URI;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.StunCandidateHarvester;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.security.LongTermCredential;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class RtcWebsocketClient
extends WebSocketClient {
    private final Logger logger;
    private final String requestId;
    private final String rtaConnectionId;
    private final SessionInfo sessionInfo;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<String, PeerSession> activeSessions;
    private final List<CandidateHarvester> candidateHarvesters;
    private final SessionManagerCore sessionManager;
    private ScheduledFuture<?> heartbeatFuture;
    private CompletableFuture<Void> onOpenFuture = new CompletableFuture();

    public RtcWebsocketClient(String authenticationToken, ExpandedSessionInfo sessionInfo, Logger logger, ScheduledExecutorService scheduledExecutorService, SessionManagerCore sessionManager) {
        super(URI.create("wss://signal.franchise.minecraft-services.net/ws/v1.0/signaling/%s".formatted(sessionInfo.getNetherNetId())));
        this.addHeader("Authorization", authenticationToken);
        this.addHeader("Session-Id", UUID.randomUUID().toString());
        this.requestId = UUID.randomUUID().toString();
        this.addHeader("Request-Id", this.requestId);
        this.rtaConnectionId = sessionInfo.getConnectionId();
        this.logger = logger;
        this.sessionInfo = sessionInfo;
        this.scheduledExecutorService = scheduledExecutorService;
        this.sessionManager = sessionManager;
        this.activeSessions = new HashMap<String, PeerSession>();
        this.candidateHarvesters = new ArrayList<CandidateHarvester>();
    }

    public CompletableFuture<Void> onOpenFuture() {
        return this.onOpenFuture;
    }

    @Override
    public void onOpen(ServerHandshake serverHandshake) {
        this.heartbeatFuture = this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.send(Constants.GSON.toJson(new WsToMessage(0, null, null))), 40L, 40L, TimeUnit.SECONDS);
        this.onOpenFuture.complete(null);
    }

    @Override
    public void onMessage(String message) {
        this.logger.debug("[" + this.rtaConnectionId + "] RTC Websocket [" + this.requestId + "] received: " + message);
        WsFromMessage messageWrapper = Constants.GSON.fromJson(message, WsFromMessage.class);
        if (messageWrapper.Type() == 2) {
            this.initialize(messageWrapper.message());
            return;
        }
        if (messageWrapper.Type() == 1) {
            this.handleDataAction(new BigInteger(messageWrapper.From()), messageWrapper.Message());
        }
    }

    @Override
    public void send(String text) {
        super.send(text);
        this.logger.debug("[" + this.rtaConnectionId + "] RTC Websocket [" + this.requestId + "] sent: " + text);
    }

    private void handleDataAction(BigInteger from, String message) {
        int typeIndex = message.indexOf(32);
        String type = message.substring(0, typeIndex);
        int sessionIdIndex = message.indexOf(32, typeIndex + 1);
        String sessionId = message.substring(typeIndex + 1, sessionIdIndex);
        String content = message.substring(sessionIdIndex + 1);
        if ("CONNECTREQUEST".equals(type)) {
            this.handleConnectRequest(from, sessionId, content);
        } else if ("CANDIDATEADD".equals(type)) {
            this.handleCandidateAdd(sessionId, content);
        }
    }

    private void handleConnectRequest(BigInteger from, String sessionId, String message) {
        PeerSession session = new PeerSession(this, this.candidateHarvesters, this.sessionManager);
        this.activeSessions.put(sessionId, session);
        session.receiveOffer(from, sessionId, message);
    }

    private void handleCandidateAdd(String sessionId, String message) {
        PeerSession session = this.activeSessions.get(sessionId);
        if (session != null) {
            session.addCandidate(message);
        }
    }

    public void handleDisconnect(String sessionId) {
        this.logger.debug("[" + this.rtaConnectionId + "] RTC Websocket [" + this.requestId + "] disconnecting session: " + sessionId);
        this.activeSessions.remove(sessionId);
    }

    private void initialize(JsonObject message) {
        this.candidateHarvesters.clear();
        JsonArray turnAuthServers = message.getAsJsonArray("TurnAuthServers");
        for (JsonElement authServerElement : turnAuthServers) {
            JsonObject authServer = authServerElement.getAsJsonObject();
            String username = authServer.get("Username").getAsString();
            String password = authServer.get("Password").getAsString();
            authServer.getAsJsonArray("Urls").forEach(url -> {
                String[] parts = url.getAsString().split(":");
                String type = parts[0];
                String host = parts[1];
                int port = Integer.parseInt(parts[2]);
                if ("stun".equals(type)) {
                    this.candidateHarvesters.add(new StunCandidateHarvester(new TransportAddress(host, port, Transport.UDP)));
                } else if ("turn".equals(type)) {
                    this.candidateHarvesters.add(new TurnCandidateHarvester(new TransportAddress(host, port, Transport.UDP), new LongTermCredential(username, password)));
                } else {
                    throw new IllegalStateException("Unexpected value: " + type);
                }
            });
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(true);
        }
        if (!this.onOpenFuture.isDone()) {
            this.onOpenFuture.completeExceptionally(new IllegalStateException("RTC Websocket [" + this.requestId + "] disconnected before onOpen was called"));
        }
        String reasonString = reason.isEmpty() && code == 1000 ? "Normal close" : reason;
        this.logger.info("[" + this.rtaConnectionId + "] RTC Websocket [" + this.requestId + "] disconnected: " + reasonString + " (" + code + ")");
    }

    @Override
    public void onError(Exception ex) {
        this.logger.error("[" + this.rtaConnectionId + "] RTC Websocket [" + this.requestId + "] error: " + ex.getMessage(), ex);
    }

    public SessionInfo sessionInfo() {
        return this.sessionInfo;
    }

    public Logger logger() {
        return this.logger;
    }

    public ScheduledExecutorService scheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

