/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.core.webrtc.encryption;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class BedrockEncryptionEncoder {
    private static final FastThreadLocal<MessageDigest> DIGEST = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (Exception var2) {
                throw new AssertionError((Object)var2);
            }
        }
    };
    private final AtomicLong packetCounter = new AtomicLong();
    private final SecretKey key;
    private final Cipher cipher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf encode(ByteBuf data) throws Exception {
        ByteBuf buf = Unpooled.buffer(data.readableBytes() + 8);
        try {
            ByteBuffer trailer = ByteBuffer.wrap(BedrockEncryptionEncoder.generateTrailer(data, this.key, this.packetCounter));
            ByteBuffer inBuffer = data.nioBuffer();
            ByteBuffer outBuffer = buf.nioBuffer(0, data.readableBytes() + 8);
            int index = this.cipher.update(inBuffer, outBuffer);
            buf.writerIndex(index += this.cipher.update(trailer, outBuffer));
            ByteBuf byteBuf = buf.retain();
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] generateTrailer(ByteBuf buf, SecretKey key, AtomicLong counter) {
        byte[] var7;
        MessageDigest digest = DIGEST.get();
        ByteBuf counterBuf = ByteBufAllocator.DEFAULT.directBuffer(8);
        try {
            counterBuf.writeLongLE(counter.getAndIncrement());
            ByteBuffer keyBuffer = ByteBuffer.wrap(key.getEncoded());
            digest.update(counterBuf.nioBuffer(0, 8));
            digest.update(buf.nioBuffer(buf.readerIndex(), buf.readableBytes()));
            digest.update(keyBuffer);
            byte[] hash = digest.digest();
            var7 = Arrays.copyOf(hash, 8);
        }
        finally {
            counterBuf.release();
            digest.reset();
        }
        return var7;
    }

    public BedrockEncryptionEncoder(SecretKey key, Cipher cipher) {
        this.key = key;
        this.cipher = cipher;
    }
}

