/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler;

import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonObject;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler.exception.InformativeHttpRequestException;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.JsonUtil;
import java.io.IOException;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;

public abstract class JsonHttpResponseHandler
implements HttpResponseHandler<JsonObject> {
    @Override
    public JsonObject handle(HttpResponse response) throws IOException {
        if (response.getContentAsString().isEmpty() && response.getStatusCode() == 204) {
            return null;
        }
        if (response.getContentAsString().isEmpty() && response.getStatusCode() >= 300) {
            throw new InformativeHttpRequestException(response, "Empty response");
        }
        if (!response.getContentType().orElse(ContentTypes.TEXT_PLAIN).getMimeType().equals(ContentTypes.APPLICATION_JSON.getMimeType())) {
            throw new InformativeHttpRequestException(response, "Wrong content type");
        }
        JsonObject obj = (JsonObject)JsonUtil.parseString(response.getContentAsString());
        if (response.getStatusCode() >= 300) {
            this.handleJsonError(response, obj);
            throw new InformativeHttpRequestException(response, response.getContentAsString());
        }
        return obj;
    }

    protected abstract void handleJsonError(HttpResponse var1, JsonObject var2) throws IOException;
}

