/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa;

import com.rtm516.mcxboxbroadcast.shaded.com.google.gson.JsonObject;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.responsehandler.MsaResponseHandler;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.AbstractStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.JsonUtil;
import com.rtm516.mcxboxbroadcast.shaded.net.raphimc.minecraftauth.util.logging.ILogger;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;

public class StepMsaToken
extends AbstractStep<MsaCodeStep.MsaCode, MsaToken> {
    public StepMsaToken(AbstractStep<?, MsaCodeStep.MsaCode> prevStep) {
        super("msaToken", prevStep);
    }

    @Override
    protected MsaToken execute(ILogger logger, HttpClient httpClient, MsaCodeStep.MsaCode msaCode) throws Exception {
        if (msaCode.msaToken != null) {
            return msaCode.msaToken;
        }
        return this.execute(logger, httpClient, "authorization_code", msaCode.getCode(), msaCode);
    }

    @Override
    public MsaToken refresh(ILogger logger, HttpClient httpClient, MsaToken msaToken) throws Exception {
        if (!msaToken.isExpired()) {
            return msaToken;
        }
        if (msaToken.getRefreshToken() != null) {
            return this.execute(logger, httpClient, "refresh_token", msaToken.getRefreshToken(), msaToken.getMsaCode());
        }
        return super.refresh(logger, httpClient, msaToken);
    }

    @Override
    public MsaToken getFromInput(ILogger logger, HttpClient httpClient, AbstractStep.InitialInput input) throws Exception {
        if (input instanceof RefreshToken) {
            RefreshToken refreshToken = (RefreshToken)input;
            return this.execute(logger, httpClient, "refresh_token", refreshToken.getRefreshToken(), new MsaCodeStep.MsaCode(null));
        }
        return (MsaToken)super.getFromInput(logger, httpClient, input);
    }

    @Override
    public MsaToken fromJson(JsonObject json) {
        MsaCodeStep.MsaCode msaCode = this.prevStep != null ? (MsaCodeStep.MsaCode)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new MsaToken(json.get("expireTimeMs").getAsLong(), json.get("accessToken").getAsString(), JsonUtil.getStringOr(json, "refreshToken", null), msaCode);
    }

    @Override
    public JsonObject toJson(MsaToken msaToken) {
        JsonObject json = new JsonObject();
        json.addProperty("expireTimeMs", msaToken.expireTimeMs);
        json.addProperty("accessToken", msaToken.accessToken);
        json.addProperty("refreshToken", msaToken.refreshToken);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, this.prevStep.toJson(msaToken.msaCode));
        }
        return json;
    }

    private MsaToken execute(ILogger logger, HttpClient httpClient, String type, String codeOrRefreshToken, MsaCodeStep.MsaCode msaCode) throws Exception {
        logger.info(this, "Getting MSA Token...");
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", this.applicationDetails.getClientId());
        postData.put("scope", this.applicationDetails.getScope());
        if (this.applicationDetails.getClientSecret() != null) {
            postData.put("client_secret", this.applicationDetails.getClientSecret());
        }
        postData.put("grant_type", type);
        if (type.equals("refresh_token")) {
            postData.put("refresh_token", codeOrRefreshToken);
        } else if (type.equals("authorization_code")) {
            postData.put("code", codeOrRefreshToken);
            if (msaCode.customRedirectUri != null) {
                postData.put("redirect_uri", msaCode.customRedirectUri);
            } else {
                postData.put("redirect_uri", this.applicationDetails.getRedirectUri());
            }
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        PostRequest postRequest = new PostRequest(this.applicationDetails.getOAuthEnvironment().getTokenUrl());
        postRequest.setContent(new URLEncodedFormContent(postData));
        JsonObject obj = httpClient.execute(postRequest, new MsaResponseHandler());
        MsaToken msaToken = new MsaToken(System.currentTimeMillis() + obj.get("expires_in").getAsLong() * 1000L, obj.get("access_token").getAsString(), JsonUtil.getStringOr(obj, "refresh_token", null), msaCode);
        logger.info(this, "Got MSA Token, expires: " + Instant.ofEpochMilli(msaToken.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return msaToken;
    }

    public static final class RefreshToken
    extends AbstractStep.InitialInput {
        private final String refreshToken;

        @Generated
        public RefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Generated
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Generated
        public String toString() {
            return "StepMsaToken.RefreshToken(refreshToken=" + this.getRefreshToken() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshToken)) {
                return false;
            }
            RefreshToken other = (RefreshToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RefreshToken;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            return result;
        }
    }

    public static final class MsaToken
    extends AbstractStep.StepResult<MsaCodeStep.MsaCode> {
        private final long expireTimeMs;
        private final String accessToken;
        private final String refreshToken;
        private final MsaCodeStep.MsaCode msaCode;

        @Override
        protected MsaCodeStep.MsaCode prevResult() {
            return this.msaCode;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        @Generated
        public MsaToken(long expireTimeMs, String accessToken, String refreshToken, MsaCodeStep.MsaCode msaCode) {
            this.expireTimeMs = expireTimeMs;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.msaCode = msaCode;
        }

        @Generated
        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Generated
        public MsaCodeStep.MsaCode getMsaCode() {
            return this.msaCode;
        }

        @Generated
        public String toString() {
            return "StepMsaToken.MsaToken(expireTimeMs=" + this.getExpireTimeMs() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", msaCode=" + this.getMsaCode() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaToken)) {
                return false;
            }
            MsaToken other = (MsaToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            MsaCodeStep.MsaCode this$msaCode = this.getMsaCode();
            MsaCodeStep.MsaCode other$msaCode = other.getMsaCode();
            return !(this$msaCode == null ? other$msaCode != null : !((Object)this$msaCode).equals(other$msaCode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MsaToken;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            MsaCodeStep.MsaCode $msaCode = this.getMsaCode();
            result = result * 59 + ($msaCode == null ? 43 : ((Object)$msaCode).hashCode());
            return result;
        }
    }
}

