/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.cmp;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Integer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DERSequence;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cmp.CMPCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cmp.CertConfirmContent;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.cmp.CertStatus;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.X509CertificateHolder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.cmp.CMPException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.cmp.CMPUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.cmp.CertificateConfirmationContent;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List<CMPCertificate> acceptedCerts = new ArrayList<CMPCertificate>();
    private List<AlgorithmIdentifier> acceptedSignatureAlgorithms = new ArrayList<AlgorithmIdentifier>();
    private List<ASN1Integer> acceptedReqIds = new ArrayList<ASN1Integer>();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder x509CertificateHolder, BigInteger bigInteger) {
        return this.addAcceptedCertificate(x509CertificateHolder, new ASN1Integer(bigInteger));
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder x509CertificateHolder, ASN1Integer aSN1Integer) {
        return this.addAcceptedCertificate(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), aSN1Integer);
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, ASN1Integer aSN1Integer) {
        this.acceptedCerts.add(cMPCertificate);
        this.acceptedSignatureAlgorithms.add(algorithmIdentifier);
        this.acceptedReqIds.add(aSN1Integer);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.acceptedCerts.size());
        for (int i = 0; i != this.acceptedCerts.size(); ++i) {
            byte[] byArray = CMPUtil.calculateCertHash(this.acceptedCerts.get(i), this.acceptedSignatureAlgorithms.get(i), digestCalculatorProvider, this.digestAlgFinder);
            ASN1Integer aSN1Integer = this.acceptedReqIds.get(i);
            aSN1EncodableVector.add(new CertStatus(byArray, aSN1Integer));
        }
        CertConfirmContent certConfirmContent = CertConfirmContent.getInstance(new DERSequence(aSN1EncodableVector));
        return new CertificateConfirmationContent(certConfirmContent, this.digestAlgFinder);
    }
}

