/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DERBitString;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf.CRMFException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.cert.crmf.PKMACBuilder;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;

abstract class PKMACValueGenerator {
    private PKMACValueGenerator() {
    }

    public static PKMACValue generate(PKMACBuilder pKMACBuilder, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        MacCalculator macCalculator = pKMACBuilder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return new PKMACValue(macCalculator.getAlgorithmIdentifier(), new DERBitString(macCalculator.getMac()));
    }
}

