/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DEROctetString;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.BlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.BufferedBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CipherParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.DataLengthException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.OutputLengthException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.engines.DSTU7624Engine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.fpe.FPEEngine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.fpe.FPEFF1Engine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.fpe.FPEFF3_1Engine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.AEADBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.AEADCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.CCMBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.CFBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.CTSBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.EAXBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.GCFBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.GCMBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.GCMSIVBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.GOFBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.KCCMBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.KCTRBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.KGCMBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.OCBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.OFBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.modes.SICBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.PKCS7Padding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.TBCPadding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.X923Padding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.paddings.ZeroBytePadding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.AEADParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.FPEParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.KeyParameter;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithIV;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithSBox;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RC2Parameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RC5Parameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.internal.asn1.cms.GCMParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.PBKDF1Key;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.PBKDF1KeyWithParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.PKCS12Key;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.GcmSpecUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.provider.symmetric.util.SpecUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.spec.AEADParameterSpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.spec.FPEParameterSpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.spec.RepeatedSecretKeySpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Strings;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class BaseBlockCipher
extends BaseWrapCipher
implements PBE {
    private static final int BUF_SIZE = 512;
    private static final Class[] availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, GcmSpecUtil.gcmSpecClass, GOST28147ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
    private BlockCipher baseEngine;
    private BlockCipherProvider engineProvider;
    private GenericBlockCipher cipher;
    private ParametersWithIV ivParam;
    private AEADParameters aeadParams;
    private int keySizeInBits;
    private int scheme = -1;
    private int digest;
    private int ivLength = 0;
    private boolean padded;
    private boolean fixedIv = true;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private String modeName = null;

    protected BaseBlockCipher(BlockCipher blockCipher) {
        this.baseEngine = blockCipher;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n, int n2, int n3, int n4) {
        this.baseEngine = blockCipher;
        this.scheme = n;
        this.digest = n2;
        this.keySizeInBits = n3;
        this.ivLength = n4;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
    }

    protected BaseBlockCipher(BlockCipherProvider blockCipherProvider) {
        this.baseEngine = blockCipherProvider.get();
        this.engineProvider = blockCipherProvider;
        this.cipher = new BufferedGenericBlockCipher(blockCipherProvider.get());
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher) {
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.ivLength = aEADBlockCipher.getAlgorithmName().indexOf("GCM") >= 0 ? 12 : this.baseEngine.getBlockSize();
        this.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    protected BaseBlockCipher(AEADCipher aEADCipher, boolean bl, int n) {
        this.baseEngine = null;
        this.fixedIv = bl;
        this.ivLength = n;
        this.cipher = new AEADGenericBlockCipher(aEADCipher);
    }

    protected BaseBlockCipher(AEADBlockCipher aEADBlockCipher, boolean bl, int n) {
        this.baseEngine = aEADBlockCipher.getUnderlyingCipher();
        this.fixedIv = bl;
        this.ivLength = n;
        this.cipher = new AEADGenericBlockCipher(aEADBlockCipher);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, int n) {
        this(blockCipher, true, n);
    }

    protected BaseBlockCipher(BlockCipher blockCipher, boolean bl, int n) {
        this.baseEngine = blockCipher;
        this.fixedIv = bl;
        this.cipher = new BufferedGenericBlockCipher(blockCipher);
        this.ivLength = n / 8;
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, int n) {
        this(bufferedBlockCipher, true, n);
    }

    protected BaseBlockCipher(BufferedBlockCipher bufferedBlockCipher, boolean bl, int n) {
        this.baseEngine = bufferedBlockCipher.getUnderlyingCipher();
        this.cipher = new BufferedGenericBlockCipher(bufferedBlockCipher);
        this.fixedIv = bl;
        this.ivLength = n / 8;
    }

    @Override
    protected int engineGetBlockSize() {
        if (this.baseEngine == null) {
            return -1;
        }
        return this.baseEngine.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.aeadParams != null) {
            return this.aeadParams.getNonce();
        }
        return this.ivParam != null ? this.ivParam.getIV() : null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = this.createParametersInstance(this.pbeAlgorithm);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this.aeadParams != null) {
                if (this.baseEngine == null) {
                    try {
                        this.engineParams = this.createParametersInstance(PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305.getId());
                        this.engineParams.init(new DEROctetString(this.aeadParams.getNonce()).getEncoded());
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                } else {
                    try {
                        this.engineParams = this.createParametersInstance("GCM");
                        this.engineParams.init(new GCMParameters(this.aeadParams.getNonce(), this.aeadParams.getMacSize() / 8).getEncoded());
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                }
            } else if (this.ivParam != null) {
                String string = this.cipher.getUnderlyingCipher().getAlgorithmName();
                if (string.indexOf(47) >= 0) {
                    string = string.substring(0, string.indexOf(47));
                }
                try {
                    this.engineParams = this.createParametersInstance(string);
                    this.engineParams.init(new IvParameterSpec(this.ivParam.getIV()));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.toString());
                }
            }
        }
        return this.engineParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (this.baseEngine == null) {
            throw new NoSuchAlgorithmException("no mode supported for this algorithm");
        }
        this.modeName = Strings.toUpperCase(string);
        if (this.modeName.equals("ECB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher(this.baseEngine);
            return;
        } else if (this.modeName.equals("CBC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(CBCBlockCipher.newInstance(this.baseEngine));
            return;
        } else if (this.modeName.startsWith("OFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int n = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, n));
                return;
            } else {
                this.cipher = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
            return;
        } else if (this.modeName.startsWith("CFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int n = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher(CFBBlockCipher.newInstance(this.baseEngine, n));
                return;
            } else {
                this.cipher = new BufferedGenericBlockCipher(CFBBlockCipher.newInstance(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
            return;
        } else if (this.modeName.startsWith("PGPCFB")) {
            boolean bl = this.modeName.equals("PGPCFBWITHIV");
            if (!bl && this.modeName.length() != 6) {
                throw new NoSuchAlgorithmException("no mode support for " + this.modeName);
            }
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new PGPCFBBlockCipher(this.baseEngine, bl));
            return;
        } else if (this.modeName.equals("OPENPGPCFB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher(new OpenPGPCFBBlockCipher(this.baseEngine));
            return;
        } else if (this.modeName.equals("FF1")) {
            this.ivLength = 0;
            this.cipher = new BufferedFPEBlockCipher(new FPEFF1Engine(this.baseEngine));
            return;
        } else if (this.modeName.equals("FF3-1")) {
            this.ivLength = 0;
            this.cipher = new BufferedFPEBlockCipher(new FPEFF3_1Engine(this.baseEngine));
            return;
        } else if (this.modeName.equals("SIC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.ivLength < 16) {
                throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
            }
            this.fixedIv = false;
            this.cipher = new BufferedGenericBlockCipher(new DefaultBufferedBlockCipher(SICBlockCipher.newInstance(this.baseEngine)));
            return;
        } else if (this.modeName.equals("CTR")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.fixedIv = false;
            this.cipher = this.baseEngine instanceof DSTU7624Engine ? new BufferedGenericBlockCipher(new DefaultBufferedBlockCipher(new KCTRBlockCipher(this.baseEngine))) : new BufferedGenericBlockCipher(new DefaultBufferedBlockCipher(SICBlockCipher.newInstance(this.baseEngine)));
            return;
        } else if (this.modeName.equals("GOFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new DefaultBufferedBlockCipher(new GOFBBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.equals("GCFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new DefaultBufferedBlockCipher(new GCFBBlockCipher(this.baseEngine)));
            return;
        } else if (this.modeName.equals("CTS")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(CBCBlockCipher.newInstance(this.baseEngine)));
            return;
        } else if (this.modeName.equals("CCM")) {
            this.ivLength = 12;
            this.cipher = this.baseEngine instanceof DSTU7624Engine ? new AEADGenericBlockCipher(new KCCMBlockCipher(this.baseEngine)) : new AEADGenericBlockCipher(CCMBlockCipher.newInstance(this.baseEngine));
            return;
        } else if (this.modeName.equals("OCB")) {
            if (this.engineProvider == null) throw new NoSuchAlgorithmException("can't support mode " + string);
            this.ivLength = 15;
            this.cipher = new AEADGenericBlockCipher(new OCBBlockCipher(this.baseEngine, this.engineProvider.get()));
            return;
        } else if (this.modeName.equals("EAX")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new AEADGenericBlockCipher(new EAXBlockCipher(this.baseEngine));
            return;
        } else if (this.modeName.equals("GCM-SIV")) {
            this.ivLength = 12;
            this.cipher = new AEADGenericBlockCipher(new GCMSIVBlockCipher(this.baseEngine));
            return;
        } else {
            if (!this.modeName.equals("GCM")) throw new NoSuchAlgorithmException("can't support mode " + string);
            if (this.baseEngine instanceof DSTU7624Engine) {
                this.ivLength = this.baseEngine.getBlockSize();
                this.cipher = new AEADGenericBlockCipher(new KGCMBlockCipher(this.baseEngine));
                return;
            } else {
                this.ivLength = 12;
                this.cipher = new AEADGenericBlockCipher(GCMBlockCipher.newInstance(this.baseEngine));
            }
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (this.baseEngine == null) {
            throw new NoSuchPaddingException("no padding supported for this algorithm");
        }
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NOPADDING")) {
            if (this.cipher.wrapOnNoPadding()) {
                this.cipher = new BufferedGenericBlockCipher(new DefaultBufferedBlockCipher(this.cipher.getUnderlyingCipher()));
            }
        } else if (string2.equals("WITHCTS") || string2.equals("CTSPADDING") || string2.equals("CS3PADDING")) {
            this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(this.cipher.getUnderlyingCipher()));
        } else {
            this.padded = true;
            if (this.isAEADModeName(this.modeName)) {
                throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            }
            if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher());
            } else if (string2.equals("ZEROBYTEPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ZeroBytePadding());
            } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO10126d2Padding());
            } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new X923Padding());
            } else if (string2.equals("ISO7816-4PADDING") || string2.equals("ISO9797-1PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO7816d4Padding());
            } else if (string2.equals("TBCPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new TBCPadding());
            } else {
                throw new NoSuchPaddingException("Padding " + string + " unknown.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        Object object3;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        this.aeadParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + (key != null ? key.getAlgorithm() : null) + " not suitable for symmetric enryption.");
        }
        if (algorithmParameterSpec == null && this.baseEngine != null && this.baseEngine.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if (this.scheme == 2 || key instanceof PKCS12Key) {
            try {
                object3 = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object3 instanceof PBEKey && this.pbeSpec == null) {
                object2 = (PBEKey)object3;
                if (object2.getSalt() == null) {
                    throw new InvalidAlgorithmParameterException("PBEKey requires parameters to specify salt");
                }
                this.pbeSpec = new PBEParameterSpec(object2.getSalt(), object2.getIterationCount());
            }
            if (this.pbeSpec == null && !(object3 instanceof PBEKey)) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            if (key instanceof BCPBEKey) {
                object2 = ((BCPBEKey)key).getParam();
                if (object2 instanceof ParametersWithIV) {
                    object = object2;
                } else {
                    if (object2 != null) throw new InvalidKeyException("Algorithm requires a PBE key suitable for PKCS12");
                    object = PBE.Util.makePBEParameters(object3.getEncoded(), 2, this.digest, this.keySizeInBits, this.ivLength * 8, this.pbeSpec, this.cipher.getAlgorithmName());
                }
            } else {
                object = PBE.Util.makePBEParameters(object3.getEncoded(), 2, this.digest, this.keySizeInBits, this.ivLength * 8, this.pbeSpec, this.cipher.getAlgorithmName());
            }
            if (object instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (key instanceof PBKDF1Key) {
            object3 = (PBKDF1Key)key;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            }
            if (object3 instanceof PBKDF1KeyWithParameters && this.pbeSpec == null) {
                this.pbeSpec = new PBEParameterSpec(((PBKDF1KeyWithParameters)object3).getSalt(), ((PBKDF1KeyWithParameters)object3).getIterationCount());
            }
            if ((object = PBE.Util.makePBEParameters(((PBKDF1Key)object3).getEncoded(), 0, this.digest, this.keySizeInBits, this.ivLength * 8, this.pbeSpec, this.cipher.getAlgorithmName())) instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (key instanceof BCPBEKey) {
            object3 = (BCPBEKey)key;
            this.pbeAlgorithm = ((BCPBEKey)object3).getOID() != null ? ((BCPBEKey)object3).getOID().getId() : ((BCPBEKey)object3).getAlgorithm();
            if (((BCPBEKey)object3).getParam() != null) {
                object = this.adjustParameters(algorithmParameterSpec, ((BCPBEKey)object3).getParam());
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
                object = PBE.Util.makePBEParameters((BCPBEKey)object3, algorithmParameterSpec, this.cipher.getUnderlyingCipher().getAlgorithmName());
            }
            if (object instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (key instanceof PBEKey) {
            object3 = (PBEKey)key;
            this.pbeSpec = (PBEParameterSpec)algorithmParameterSpec;
            if (object3 instanceof PKCS12KeyWithParameters && this.pbeSpec == null) {
                this.pbeSpec = new PBEParameterSpec(object3.getSalt(), object3.getIterationCount());
            }
            if ((object = PBE.Util.makePBEParameters(object3.getEncoded(), this.scheme, this.digest, this.keySizeInBits, this.ivLength * 8, this.pbeSpec, this.cipher.getAlgorithmName())) instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (!(key instanceof RepeatedSecretKeySpec)) {
            if (this.scheme == 0 || this.scheme == 4 || this.scheme == 1 || this.scheme == 5) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            object = new KeyParameter(key.getEncoded());
        } else {
            object = null;
        }
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            if (!this.isAEADModeName(this.modeName) && !(this.cipher instanceof AEADGenericBlockCipher)) {
                throw new InvalidAlgorithmParameterException("AEADParameterSpec can only be used with AEAD modes.");
            }
            object3 = (AEADParameterSpec)algorithmParameterSpec;
            object2 = object instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object).getParameters() : (KeyParameter)object;
            this.aeadParams = new AEADParameters((KeyParameter)object2, ((AEADParameterSpec)object3).getMacSizeInBits(), ((AEADParameterSpec)object3).getNonce(), ((AEADParameterSpec)object3).getAssociatedData());
            object = this.aeadParams;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                object3 = (IvParameterSpec)algorithmParameterSpec;
                if (((IvParameterSpec)object3).getIV().length != this.ivLength && !(this.cipher instanceof AEADGenericBlockCipher) && this.fixedIv) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.ivLength + " bytes long.");
                }
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((IvParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((IvParameterSpec)object3).getIV());
                this.ivParam = (ParametersWithIV)object;
            } else if (this.modeName != null && this.modeName.equals("ECB")) {
                throw new InvalidAlgorithmParameterException("ECB mode does not use an IV");
            }
        } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
            object3 = (GOST28147ParameterSpec)algorithmParameterSpec;
            object = new ParametersWithSBox(new KeyParameter(key.getEncoded()), ((GOST28147ParameterSpec)algorithmParameterSpec).getSBox());
            if (((GOST28147ParameterSpec)object3).getIV() != null && this.ivLength != 0) {
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((GOST28147ParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((GOST28147ParameterSpec)object3).getIV());
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            object3 = (RC2ParameterSpec)algorithmParameterSpec;
            object = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
            if (((RC2ParameterSpec)object3).getIV() != null && this.ivLength != 0) {
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((RC2ParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((RC2ParameterSpec)object3).getIV());
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            object3 = (RC5ParameterSpec)algorithmParameterSpec;
            object = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)algorithmParameterSpec).getRounds());
            if (!this.baseEngine.getAlgorithmName().startsWith("RC5")) throw new InvalidAlgorithmParameterException("RC5 parameters passed to a cipher that is not RC5.");
            if (this.baseEngine.getAlgorithmName().equals("RC5-32")) {
                if (((RC5ParameterSpec)object3).getWordSize() != 32) {
                    throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 32 not " + ((RC5ParameterSpec)object3).getWordSize() + ".");
                }
            } else if (this.baseEngine.getAlgorithmName().equals("RC5-64") && ((RC5ParameterSpec)object3).getWordSize() != 64) {
                throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 64 not " + ((RC5ParameterSpec)object3).getWordSize() + ".");
            }
            if (((RC5ParameterSpec)object3).getIV() != null && this.ivLength != 0) {
                object = object instanceof ParametersWithIV ? new ParametersWithIV(((ParametersWithIV)object).getParameters(), ((RC5ParameterSpec)object3).getIV()) : new ParametersWithIV((CipherParameters)object, ((RC5ParameterSpec)object3).getIV());
                this.ivParam = (ParametersWithIV)object;
            }
        } else if (algorithmParameterSpec instanceof FPEParameterSpec) {
            object3 = (FPEParameterSpec)algorithmParameterSpec;
            object = new FPEParameters((KeyParameter)object, ((FPEParameterSpec)object3).getRadixConverter(), ((FPEParameterSpec)object3).getTweak(), ((FPEParameterSpec)object3).isUsingInverseFunction());
        } else if (GcmSpecUtil.isGcmSpec(algorithmParameterSpec)) {
            if (!this.isAEADModeName(this.modeName) && !(this.cipher instanceof AEADGenericBlockCipher)) {
                throw new InvalidAlgorithmParameterException("GCMParameterSpec can only be used with AEAD modes.");
            }
            object3 = object instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object).getParameters() : (KeyParameter)object;
            this.aeadParams = GcmSpecUtil.extractAeadParameters((KeyParameter)object3, algorithmParameterSpec);
            object = this.aeadParams;
        } else if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(object instanceof ParametersWithIV) && !(object instanceof AEADParameters)) {
            object3 = secureRandom;
            if (object3 == null) {
                object3 = CryptoServicesRegistrar.getSecureRandom();
            }
            if (n == 1 || n == 3) {
                object2 = new byte[this.ivLength];
                ((SecureRandom)object3).nextBytes((byte[])object2);
                object = new ParametersWithIV((CipherParameters)object, (byte[])object2);
                this.ivParam = (ParametersWithIV)object;
            } else if (this.cipher.getUnderlyingCipher().getAlgorithmName().indexOf("PGPCFB") < 0) {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        if (secureRandom != null && this.padded) {
            object = new ParametersWithRandom((CipherParameters)object, secureRandom);
        }
        try {
            switch (n) {
                case 1: 
                case 3: {
                    this.cipher.init(true, (CipherParameters)object);
                    break;
                }
                case 2: 
                case 4: {
                    this.cipher.init(false, (CipherParameters)object);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + n + " passed");
                }
            }
            if (!(this.cipher instanceof AEADGenericBlockCipher) || this.aeadParams != null) return;
            object3 = ((AEADGenericBlockCipher)this.cipher).cipher;
            this.aeadParams = new AEADParameters((KeyParameter)this.ivParam.getParameters(), object3.getMac().length * 8, this.ivParam.getIV());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Exception exception) {
            throw new BaseWrapCipher.InvalidKeyOrParametersException(exception.getMessage(), exception);
        }
    }

    private CipherParameters adjustParameters(AlgorithmParameterSpec algorithmParameterSpec, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithIV) {
            CipherParameters cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
                this.ivParam = new ParametersWithIV(cipherParameters2, ivParameterSpec.getIV());
                cipherParameters = this.ivParam;
            } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
                cipherParameters = new ParametersWithSBox(cipherParameters, gOST28147ParameterSpec.getSBox());
                if (gOST28147ParameterSpec.getIV() != null && this.ivLength != 0) {
                    this.ivParam = new ParametersWithIV(cipherParameters2, gOST28147ParameterSpec.getIV());
                    cipherParameters = this.ivParam;
                }
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.ivParam = new ParametersWithIV(cipherParameters, ivParameterSpec.getIV());
            cipherParameters = this.ivParam;
        } else if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
            GOST28147ParameterSpec gOST28147ParameterSpec = (GOST28147ParameterSpec)algorithmParameterSpec;
            cipherParameters = new ParametersWithSBox(cipherParameters, gOST28147ParameterSpec.getSBox());
            if (gOST28147ParameterSpec.getIV() != null && this.ivLength != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, gOST28147ParameterSpec.getIV());
            }
        }
        return cipherParameters;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null && (algorithmParameterSpec = SpecUtil.extractSpec(algorithmParameters, availableSpecs)) == null) {
            throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
        }
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.cipher.updateAAD(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n >= 1) {
            if (byteBuffer.hasArray()) {
                this.engineUpdateAAD(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
                byteBuffer.position(byteBuffer.limit());
            } else if (n <= 512) {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                this.engineUpdateAAD(byArray, 0, byArray.length);
                Arrays.fill(byArray, (byte)0);
            } else {
                int n2;
                byte[] byArray = new byte[512];
                do {
                    n2 = Math.min(byArray.length, n);
                    byteBuffer.get(byArray, 0, n2);
                    this.engineUpdateAAD(byArray, 0, n2);
                } while ((n -= n2) > 0);
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = this.cipher.getUpdateOutputSize(n2);
        if (n3 > 0) {
            byte[] byArray2 = new byte[n3];
            int n4 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
            if (n4 == 0) {
                return null;
            }
            if (n4 != byArray2.length) {
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
                return byArray3;
            }
            return byArray2;
        }
        this.cipher.processBytes(byArray, n, n2, null, 0);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (n3 + this.cipher.getUpdateOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalStateException(dataLengthException.toString());
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3 = 0;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        if (n2 != 0) {
            n3 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
        }
        try {
            n3 += this.cipher.doFinal(byArray2, n3);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        if (n3 > byArray2.length) {
            throw new IllegalBlockSizeException("internal buffer overflow");
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int n4 = 0;
        if (n3 + this.engineGetOutputSize(n2) > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            if (n2 != 0) {
                n4 = this.cipher.processBytes(byArray, n, n2, byArray2, n3);
            }
            return n4 + this.cipher.doFinal(byArray2, n3 + n4);
        }
        catch (OutputLengthException outputLengthException) {
            throw new IllegalBlockSizeException(outputLengthException.getMessage());
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
    }

    private boolean isAEADModeName(String string) {
        return "CCM".equals(string) || "EAX".equals(string) || "GCM".equals(string) || "GCM-SIV".equals(string) || "OCB".equals(string);
    }

    private static class AEADGenericBlockCipher
    implements GenericBlockCipher {
        private static final Constructor aeadBadTagConstructor;
        private AEADCipher cipher;

        private static Constructor findExceptionConstructor(Class clazz) {
            try {
                return clazz.getConstructor(String.class);
            }
            catch (Exception exception) {
                return null;
            }
        }

        AEADGenericBlockCipher(AEADCipher aEADCipher) {
            this.cipher = aEADCipher;
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public String getAlgorithmName() {
            if (this.cipher instanceof AEADBlockCipher) {
                return ((AEADBlockCipher)this.cipher).getUnderlyingCipher().getAlgorithmName();
            }
            return this.cipher.getAlgorithmName();
        }

        @Override
        public boolean wrapOnNoPadding() {
            return false;
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            if (this.cipher instanceof AEADBlockCipher) {
                return ((AEADBlockCipher)this.cipher).getUnderlyingCipher();
            }
            return null;
        }

        @Override
        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            this.cipher.processAADBytes(byArray, n, n2);
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
            return this.cipher.processByte(by, byArray, n);
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }

        @Override
        public int doFinal(byte[] byArray, int n) throws IllegalStateException, BadPaddingException {
            try {
                return this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if (aeadBadTagConstructor != null) {
                    BadPaddingException badPaddingException = null;
                    try {
                        badPaddingException = (BadPaddingException)aeadBadTagConstructor.newInstance(invalidCipherTextException.getMessage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (badPaddingException != null) {
                        throw badPaddingException;
                    }
                }
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }

        static {
            Class clazz = ClassUtil.loadClass(BaseBlockCipher.class, "javax.crypto.AEADBadTagException");
            aeadBadTagConstructor = clazz != null ? AEADGenericBlockCipher.findExceptionConstructor(clazz) : null;
        }
    }

    private static class BufferedFPEBlockCipher
    implements GenericBlockCipher {
        private FPEEngine cipher;
        private BaseWrapCipher.ErasableOutputStream eOut = new BaseWrapCipher.ErasableOutputStream();

        BufferedFPEBlockCipher(FPEEngine fPEEngine) {
            this.cipher = fPEEngine;
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public boolean wrapOnNoPadding() {
            return false;
        }

        @Override
        public String getAlgorithmName() {
            return this.cipher.getAlgorithmName();
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            throw new IllegalStateException("not applicable for FPE");
        }

        @Override
        public int getOutputSize(int n) {
            return this.eOut.size() + n;
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return 0;
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("AAD is not supported in the current mode.");
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
            this.eOut.write(by);
            return 0;
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
            this.eOut.write(byArray, n, n2);
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doFinal(byte[] byArray, int n) throws IllegalStateException, BadPaddingException {
            try {
                int n2 = this.cipher.processBlock(this.eOut.getBuf(), 0, this.eOut.size(), byArray, n);
                return n2;
            }
            finally {
                this.eOut.erase();
            }
        }
    }

    private static class BufferedGenericBlockCipher
    implements GenericBlockCipher {
        private BufferedBlockCipher cipher;

        BufferedGenericBlockCipher(BufferedBlockCipher bufferedBlockCipher) {
            this.cipher = bufferedBlockCipher;
        }

        BufferedGenericBlockCipher(BlockCipher blockCipher) {
            this(blockCipher, new PKCS7Padding());
        }

        BufferedGenericBlockCipher(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
            this.cipher = new PaddedBufferedBlockCipher(blockCipher, blockCipherPadding);
        }

        @Override
        public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
            this.cipher.init(bl, cipherParameters);
        }

        @Override
        public boolean wrapOnNoPadding() {
            return !(this.cipher instanceof CTSBlockCipher);
        }

        @Override
        public String getAlgorithmName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public BlockCipher getUnderlyingCipher() {
            return this.cipher.getUnderlyingCipher();
        }

        @Override
        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        @Override
        public int getUpdateOutputSize(int n) {
            return this.cipher.getUpdateOutputSize(n);
        }

        @Override
        public void updateAAD(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException("AAD is not supported in the current mode.");
        }

        @Override
        public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
            return this.cipher.processByte(by, byArray, n);
        }

        @Override
        public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
            return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }

        @Override
        public int doFinal(byte[] byArray, int n) throws IllegalStateException, BadPaddingException {
            try {
                return this.cipher.doFinal(byArray, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }
    }

    private static interface GenericBlockCipher {
        public void init(boolean var1, CipherParameters var2) throws IllegalArgumentException;

        public boolean wrapOnNoPadding();

        public String getAlgorithmName();

        public BlockCipher getUnderlyingCipher();

        public int getOutputSize(int var1);

        public int getUpdateOutputSize(int var1);

        public void updateAAD(byte[] var1, int var2, int var3);

        public int processByte(byte var1, byte[] var2, int var3) throws DataLengthException;

        public int processBytes(byte[] var1, int var2, int var3, byte[] var4, int var5) throws DataLengthException;

        public int doFinal(byte[] var1, int var2) throws IllegalStateException, BadPaddingException;
    }
}

