/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

class DefaultSSLContextSpi
extends ProvSSLContextSpi {
    private static final Logger LOG = Logger.getLogger(DefaultSSLContextSpi.class.getName());

    private static Exception avoidCapturingException(Exception exception) {
        return new KeyManagementException(exception.getMessage());
    }

    static ProvSSLContextSpi getDefaultInstance() throws Exception {
        if (null != LazyInstance.initException) {
            throw LazyInstance.initException;
        }
        return LazyInstance.instance;
    }

    DefaultSSLContextSpi(boolean bl, JcaTlsCryptoProvider jcaTlsCryptoProvider) throws KeyManagementException {
        super(bl, jcaTlsCryptoProvider, null);
        if (null != LazyManagers.initException) {
            throw new KeyManagementException("Default key/trust managers unavailable", LazyManagers.initException);
        }
        super.engineInit(LazyManagers.keyManagers, LazyManagers.trustManagers, null);
    }

    @Override
    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        throw new KeyManagementException("Default SSLContext is initialized automatically");
    }

    private static class LazyInstance {
        private static final Exception initException;
        private static final DefaultSSLContextSpi instance;

        private LazyInstance() {
        }

        static {
            Exception exception = LazyManagers.initException;
            DefaultSSLContextSpi defaultSSLContextSpi = null;
            if (null == exception) {
                try {
                    defaultSSLContextSpi = new DefaultSSLContextSpi(false, new JcaTlsCryptoProvider());
                }
                catch (Exception exception2) {
                    LOG.log(Level.WARNING, "Failed to load default SSLContext", exception2);
                    exception = DefaultSSLContextSpi.avoidCapturingException(exception2);
                }
            }
            initException = exception;
            instance = defaultSSLContextSpi;
        }
    }

    private static class LazyManagers {
        private static final Exception initException;
        private static final KeyManager[] keyManagers;
        private static final TrustManager[] trustManagers;

        private LazyManagers() {
        }

        static {
            Exception exception = null;
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            try {
                trustManagerArray = ProvSSLContextSpi.getDefaultTrustManagers();
            }
            catch (Exception exception2) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", exception2);
                exception = exception2;
            }
            if (null == exception) {
                try {
                    keyManagerArray = ProvSSLContextSpi.getDefaultKeyManagers();
                }
                catch (Exception exception3) {
                    LOG.log(Level.WARNING, "Failed to load default key managers", exception3);
                    exception = exception3;
                }
            }
            if (null != exception) {
                exception = DefaultSSLContextSpi.avoidCapturingException(exception);
                keyManagerArray = null;
                trustManagerArray = null;
            }
            initException = exception;
            keyManagers = keyManagerArray;
            trustManagers = trustManagerArray;
        }
    }
}

