/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ReflectionUtil;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

abstract class KeyStoreUtil {
    private static final Method getProtectionAlgorithm = ReflectionUtil.getMethod("java.security.KeyStore$PasswordProtection", "getProtectionAlgorithm", new Class[0]);

    KeyStoreUtil() {
    }

    static Key getKey(KeyStore keyStore, String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (null == protectionParameter) {
            throw new UnrecoverableKeyException("requested key requires a password");
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
            if (null != getProtectionAlgorithm && null != ReflectionUtil.invokeGetter(passwordProtection, getProtectionAlgorithm)) {
                throw new KeyStoreException("unsupported password protection algorithm");
            }
            return keyStore.getKey(string, passwordProtection.getPassword());
        }
        throw new UnsupportedOperationException();
    }
}

