/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCSNIServerName;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.JsseSecurityParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.JsseSessionParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.JsseUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvSSLSessionBase;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.ProtocolVersion;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SecurityParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

class ProvSSLSessionHandshake
extends ProvSSLSessionBase {
    protected final SecurityParameters securityParameters;
    protected final JsseSecurityParameters jsseSecurityParameters;

    ProvSSLSessionHandshake(ProvSSLSessionContext provSSLSessionContext, String string, int n, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters) {
        super(provSSLSessionContext, string, n);
        this.securityParameters = securityParameters;
        this.jsseSecurityParameters = jsseSecurityParameters;
    }

    String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.securityParameters);
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.securityParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.securityParameters.getSessionID();
    }

    @Override
    protected JsseSecurityParameters getJsseSecurityParameters() {
        return this.jsseSecurityParameters;
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return null;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.securityParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return this.jsseSecurityParameters.signatureSchemes.getLocalJcaSignatureAlgorithms();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithmsBC() {
        return this.jsseSecurityParameters.signatureSchemes.getLocalJcaSignatureAlgorithmsBC();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.securityParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return this.jsseSecurityParameters.signatureSchemes.getPeerJcaSignatureAlgorithms();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithmsBC() {
        return this.jsseSecurityParameters.signatureSchemes.getPeerJcaSignatureAlgorithmsBC();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.securityParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        Vector vector = this.securityParameters.getClientServerNames();
        return JsseUtils.convertSNIServerNames(vector);
    }

    @Override
    public List<byte[]> getStatusResponses() {
        List<byte[]> list = this.jsseSecurityParameters.statusResponses;
        if (null == list || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(list.size());
        for (byte[] byArray : list) {
            arrayList.add((byte[])byArray.clone());
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    protected void invalidateTLS() {
    }
}

