/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.util;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.BCSSLSocket;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jsse.util.CustomSSLSocketFactory;
import java.net.Socket;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SetHostSocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SetHostSocketFactory.class.getName());
    protected static final ThreadLocal<SetHostSocketFactory> threadLocal = new ThreadLocal();
    protected final URL url;

    public static SocketFactory getDefault() {
        SSLSocketFactory sSLSocketFactory = threadLocal.get();
        if (null != sSLSocketFactory) {
            return sSLSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SetHostSocketFactory(SSLSocketFactory sSLSocketFactory, URL uRL) {
        super(sSLSocketFactory);
        this.url = uRL;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket socket) {
        if (this.url != null && socket instanceof BCSSLSocket) {
            BCSSLSocket bCSSLSocket = (BCSSLSocket)((Object)socket);
            String string = this.url.getHost();
            if (string != null) {
                LOG.fine("Setting host on socket: " + string);
                bCSSLSocket.setHost(string);
            }
        }
        return socket;
    }
}

