/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.picnic;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicKeyGenerationParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicKeyPairGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.picnic.BCPicnicPrivateKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.picnic.BCPicnicPublicKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.jcajce.spec.PicnicParameterSpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class PicnicKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    PicnicKeyGenerationParameters param;
    PicnicKeyPairGenerator engine = new PicnicKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public PicnicKeyPairGeneratorSpi() {
        super("Picnic");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = PicnicKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new PicnicKeyGenerationParameters(secureRandom, (PicnicParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof PicnicParameterSpec) {
            PicnicParameterSpec picnicParameterSpec = (PicnicParameterSpec)algorithmParameterSpec;
            return picnicParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new PicnicKeyGenerationParameters(this.random, PicnicParameters.picnicl3ur);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        PicnicPublicKeyParameters picnicPublicKeyParameters = (PicnicPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        PicnicPrivateKeyParameters picnicPrivateKeyParameters = (PicnicPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCPicnicPublicKey(picnicPublicKeyParameters), new BCPicnicPrivateKey(picnicPrivateKeyParameters));
    }

    static {
        parameters.put(PicnicParameterSpec.picnicl1fs.getName(), PicnicParameters.picnicl1fs);
        parameters.put(PicnicParameterSpec.picnicl1ur.getName(), PicnicParameters.picnicl1ur);
        parameters.put(PicnicParameterSpec.picnicl3fs.getName(), PicnicParameters.picnicl3fs);
        parameters.put(PicnicParameterSpec.picnicl3ur.getName(), PicnicParameters.picnicl3ur);
        parameters.put(PicnicParameterSpec.picnicl5fs.getName(), PicnicParameters.picnicl5fs);
        parameters.put(PicnicParameterSpec.picnicl5ur.getName(), PicnicParameters.picnicl5ur);
        parameters.put(PicnicParameterSpec.picnic3l1.getName(), PicnicParameters.picnic3l1);
        parameters.put(PicnicParameterSpec.picnic3l3.getName(), PicnicParameters.picnic3l3);
        parameters.put(PicnicParameterSpec.picnic3l5.getName(), PicnicParameters.picnic3l5);
        parameters.put(PicnicParameterSpec.picnicl1full.getName(), PicnicParameters.picnicl1full);
        parameters.put(PicnicParameterSpec.picnicl3full.getName(), PicnicParameters.picnicl3full);
        parameters.put(PicnicParameterSpec.picnicl5full.getName(), PicnicParameters.picnicl5full);
    }
}

