/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSRecordLayer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DTLSReliableHandshake;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.MaxFragmentLength;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SecurityParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsContext;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsProtocol;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DTLSProtocol {
    protected DTLSProtocol() {
    }

    protected void processFinished(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = TlsUtils.readFully(byArray2.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(DTLSRecordLayer dTLSRecordLayer, short s2) throws IOException {
        if (s2 >= 0) {
            if (!MaxFragmentLength.isValid(s2)) {
                throw new TlsFatalAlert(80);
            }
            int n = 1 << 8 + s2;
            dTLSRecordLayer.setPlaintextLimit(n);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean bl, Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        return TlsUtils.processMaxFragmentLengthExtension(bl ? null : hashtable, hashtable2, s2);
    }

    protected static byte[] generateCertificate(TlsContext tlsContext, Certificate certificate, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificate.encode(tlsContext, byteArrayOutputStream, outputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData(byteArrayOutputStream, vector);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void sendCertificateMessage(TlsContext tlsContext, DTLSReliableHandshake dTLSReliableHandshake, Certificate certificate, OutputStream outputStream) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        byte[] byArray = DTLSProtocol.generateCertificate(tlsContext, certificate, outputStream);
        dTLSReliableHandshake.sendMessage((short)11, byArray);
        securityParameters.localCertificate = certificate;
    }

    protected static int validateSelectedCipherSuite(int n, short s2) throws IOException {
        int n2;
        int n3 = TlsUtils.getEncryptionAlgorithm(n);
        if (0 != n3 && ((n2 = TlsUtils.getEncryptionAlgorithmType(n3)) < 0 || 0 == n2)) {
            throw new TlsFatalAlert(s2);
        }
        return n;
    }
}

