/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyShareEntry {
    protected final int namedGroup;
    protected final byte[] keyExchange;

    private static boolean checkKeyExchangeLength(int n) {
        return 0 < n && n < 65536;
    }

    public KeyShareEntry(int n, byte[] byArray) {
        if (!TlsUtils.isValidUint16(n)) {
            throw new IllegalArgumentException("'namedGroup' should be a uint16");
        }
        if (null == byArray) {
            throw new NullPointerException("'keyExchange' cannot be null");
        }
        if (!KeyShareEntry.checkKeyExchangeLength(byArray.length)) {
            throw new IllegalArgumentException("'keyExchange' must have length from 1 to (2^16 - 1)");
        }
        this.namedGroup = n;
        this.keyExchange = byArray;
    }

    public int getNamedGroup() {
        return this.namedGroup;
    }

    public byte[] getKeyExchange() {
        return this.keyExchange;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint16(this.getNamedGroup(), outputStream);
        TlsUtils.writeOpaque16(this.getKeyExchange(), outputStream);
    }

    public static KeyShareEntry parse(InputStream inputStream) throws IOException {
        int n = TlsUtils.readUint16(inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        return new KeyShareEntry(n, byArray);
    }
}

