/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.AbstractTlsKeyExchange;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DigestInputBuffer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentialedSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentials;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsDHGroupVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsDHUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsDHEKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsCertificate serverCertificate = null;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 3: 
            case 5: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int n, TlsDHGroupVerifier tlsDHGroupVerifier) {
        this(n, tlsDHGroupVerifier, null);
    }

    public TlsDHEKeyExchange(int n, TlsDHConfig tlsDHConfig) {
        this(n, null, tlsDHConfig);
    }

    private TlsDHEKeyExchange(int n, TlsDHGroupVerifier tlsDHGroupVerifier, TlsDHConfig tlsDHConfig) {
        super(TlsDHEKeyExchange.checkKeyExchange(n));
        this.dhGroupVerifier = tlsDHGroupVerifier;
        this.dhConfig = tlsDHConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireSignerCredentials(tlsCredentials);
    }

    @Override
    public void processServerCertificate(Certificate certificate) throws IOException {
        this.serverCertificate = certificate.getCertificateAt(0);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        TlsDHUtils.writeDHConfig(this.dhConfig, digestInputBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, digestInputBuffer);
        TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, null, digestInputBuffer);
        return digestInputBuffer.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, digestInputBuffer);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque16(teeInputStream, 1);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, inputStream, this.serverCertificate, null, digestInputBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(tlsCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    @Override
    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        this.agreement.receivePeerValue(TlsUtils.readOpaque16(inputStream, 1));
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

