/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.AbstractTlsKeyExchange;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsCredentials;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsECCUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsECDHanonKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 20: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHanonKeyExchange(int n) {
        this(n, null);
    }

    public TlsECDHanonKeyExchange(int n, TlsECConfig tlsECConfig) {
        super(TlsECDHanonKeyExchange.checkKeyExchange(n));
        this.ecConfig = tlsECConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
    }

    @Override
    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsECCUtils.writeECConfig(this.ecConfig, byteArrayOutputStream);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, inputStream);
        byte[] byArray = TlsUtils.readOpaque8(inputStream, 1);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        this.generateEphemeral(outputStream);
    }

    @Override
    public void processClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque8(inputStream, 1);
        this.processEphemeral(byArray);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }

    protected void generateEphemeral(OutputStream outputStream) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(byArray, outputStream);
    }

    protected void processEphemeral(byte[] byArray) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), byArray);
        this.agreement.receivePeerValue(byArray);
    }
}

