/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.BigIntegers;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Integers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;

public class TlsSRPUtils {
    public static final Integer EXT_SRP = Integers.valueOf(12);

    public static void addSRPExtension(Hashtable hashtable, byte[] byArray) throws IOException {
        hashtable.put(EXT_SRP, TlsSRPUtils.createSRPExtension(byArray));
    }

    public static byte[] getSRPExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_SRP);
        return byArray == null ? null : TlsSRPUtils.readSRPExtension(byArray);
    }

    public static byte[] createSRPExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeOpaque8(byArray);
    }

    public static byte[] readSRPExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        return TlsUtils.decodeOpaque8(byArray, 1);
    }

    public static BigInteger readSRPParameter(InputStream inputStream) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(inputStream, 1));
    }

    public static void writeSRPParameter(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(bigInteger), outputStream);
    }

    public static boolean isSRPCipherSuite(int n) {
        switch (TlsUtils.getKeyExchangeAlgorithm(n)) {
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }
}

